/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.image;

import com.agentsflex.core.image.Image;
import com.agentsflex.core.util.Metadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImageResponse
extends Metadata {
    private List<Image> images;
    private boolean error;
    private String errorMessage;

    public static ImageResponse error(String errMessage) {
        ImageResponse imageResponse = new ImageResponse();
        imageResponse.setError(true);
        imageResponse.setErrorMessage(errMessage);
        return imageResponse;
    }

    public List<Image> getImages() {
        return this.images != null ? this.images : Collections.emptyList();
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public void addImage(String url) {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        this.images.add(Image.ofUrl(url));
    }

    public void addImage(byte[] bytes) {
        if (this.images == null) {
            this.images = new ArrayList<Image>();
        }
        this.images.add(Image.ofBytes(bytes));
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String toString() {
        return "ImageResponse{images=" + this.images + ", error=" + this.error + ", errorMessage='" + this.errorMessage + '\'' + ", metadataMap=" + this.metadataMap + '}';
    }
}

