/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client;

import com.agentsflex.core.llm.ChatContext;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.HistoriesPrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;

public class BaseLlmClientListener
implements LlmClientListener {
    private final StreamResponseListener streamResponseListener;
    private final Prompt prompt;
    private final AiMessageParser messageParser;
    private final StringBuilder fullMessage = new StringBuilder();
    private AiMessage lastAiMessage;
    private final ChatContext context;

    public BaseLlmClientListener(Llm llm, LlmClient client, StreamResponseListener streamResponseListener, Prompt prompt, AiMessageParser messageParser) {
        this.streamResponseListener = streamResponseListener;
        this.prompt = prompt;
        this.messageParser = messageParser;
        this.context = new ChatContext(llm, client);
    }

    @Override
    public void onStart(LlmClient client) {
        this.streamResponseListener.onStart(this.context);
    }

    @Override
    public void onMessage(LlmClient client, String response) {
        if (StringUtil.noText(response) || "[DONE]".equalsIgnoreCase(response.trim())) {
            return;
        }
        try {
            JSONObject jsonObject = JSON.parseObject((String)response);
            this.lastAiMessage = (AiMessage)this.messageParser.parse(jsonObject);
            String content = this.lastAiMessage.getContent();
            if (Objects.nonNull(content)) {
                this.fullMessage.append(content);
            }
            this.lastAiMessage.setFullContent(this.fullMessage.toString());
            AiMessageResponse aiMessageResponse = new AiMessageResponse(this.prompt, response, this.lastAiMessage);
            this.streamResponseListener.onMessage(this.context, aiMessageResponse);
        }
        catch (Exception err) {
            this.streamResponseListener.onFailure(this.context, err);
        }
    }

    @Override
    public void onStop(LlmClient client) {
        if (this.lastAiMessage != null && this.prompt instanceof HistoriesPrompt) {
            ((HistoriesPrompt)this.prompt).addMessage(this.lastAiMessage);
        }
        this.context.addLastAiMessage(this.lastAiMessage);
        this.streamResponseListener.onStop(this.context);
    }

    @Override
    public void onFailure(LlmClient client, Throwable throwable) {
        this.streamResponseListener.onFailure(this.context, throwable);
    }
}

