/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util;

import com.agentsflex.core.util.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NamedThreadPools {
    public static ExecutorService newFixedThreadPool(String prefix) {
        int nThreads = Runtime.getRuntime().availableProcessors();
        return NamedThreadPools.newFixedThreadPool(nThreads, prefix);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String name) {
        return Executors.newFixedThreadPool(nThreads, new NamedThreadFactory(name));
    }

    public static ExecutorService newCachedThreadPool(String name) {
        return NamedThreadPools.newCachedThreadPool(new NamedThreadFactory(name));
    }

    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String name) {
        return NamedThreadPools.newScheduledThreadPool(corePoolSize, new NamedThreadFactory(name));
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }
}

