/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.chatglm;

import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.llm.chatglm.ChatglmLlmConfig;
import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;

public class ChatglmLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat();
    private static final String id = "HS256";
    private static final String jcaName = "HmacSHA256";
    private static final MacAlgorithm macAlgorithm;

    public static String createAuthorizationToken(ChatglmLlmConfig config) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("alg", id);
        headers.put("sign_type", "SIGN");
        long nowMillis = System.currentTimeMillis();
        String[] idAndSecret = config.getApiKey().split("\\.");
        HashMap<String, Object> payloadMap = new HashMap<String, Object>();
        payloadMap.put("api_key", idAndSecret[0]);
        payloadMap.put("exp", nowMillis + 3600000L);
        payloadMap.put("timestamp", nowMillis);
        String payloadJsonString = JSON.toJSONString(payloadMap);
        byte[] bytes = idAndSecret[1].getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(bytes, jcaName);
        JwtBuilder builder = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().content(payloadJsonString).header().add(headers)).and()).signWith((Key)secretKey, (SecureDigestAlgorithm)macAlgorithm);
        return builder.compact();
    }

    public static AiMessageParser getAiMessageParser(boolean isStream) {
        return DefaultAiMessageParser.getChatGPTMessageParser((boolean)isStream);
    }

    public static String promptToPayload(Prompt prompt, ChatglmLlmConfig config, boolean withStream, ChatOptions options) {
        List messages = prompt.toMessages();
        Message message = (Message)CollectionUtil.lastItem((List)messages);
        return Maps.of((String)"model", (Object)config.getModel()).set("messages", promptFormat.toMessagesJsonObject(messages)).setIf(withStream, "stream", (Object)true).setIfNotEmpty("tools", promptFormat.toFunctionsJsonObject(message)).setIfContainsKey("tools", "tool_choice", (Object)MessageUtil.getToolChoice((Message)message)).setIfNotNull("top_p", (Object)options.getTopP()).setIfNotEmpty("stop", (Object)options.getStop()).setIf(map -> !map.containsKey((Object)"tools") && options.getTemperature().floatValue() > 0.0f, "temperature", (Object)options.getTemperature()).setIf(map -> !map.containsKey((Object)"tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).toJSON();
    }

    public static MessageStatus parseMessageStatus(String status) {
        return "stop".equals(status) ? MessageStatus.END : MessageStatus.MIDDLE;
    }

    static {
        try {
            int minKeyBitLength = 128;
            Class<?> c = Class.forName("io.jsonwebtoken.impl.security.DefaultMacAlgorithm");
            Constructor<?> ctor = c.getDeclaredConstructor(String.class, String.class, Integer.TYPE);
            ctor.setAccessible(true);
            macAlgorithm = (MacAlgorithm)ctor.newInstance(id, jcaName, minKeyBitLength);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

