/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.coze;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatContext;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.coze.CozeChatContext;
import com.agentsflex.llm.coze.CozeChatOptions;
import com.agentsflex.llm.coze.CozeLlmConfig;
import com.agentsflex.llm.coze.CozeLlmUtil;
import com.agentsflex.llm.coze.CozeRequestListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

public class CozeLlm
extends BaseLlm<CozeLlmConfig> {
    private final HttpClient httpClient = new HttpClient();
    private final AiMessageParser aiMessageParser = CozeLlmUtil.getAiMessageParser();

    public CozeLlm(CozeLlmConfig config) {
        super((LlmConfig)config);
    }

    private Map<String, String> buildHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((CozeLlmConfig)this.config).getApiKey());
        return headers;
    }

    private void botChat(Prompt prompt, CozeRequestListener listener, ChatOptions chatOptions, boolean stream) {
        String botId = ((CozeLlmConfig)this.config).getDefaultBotId();
        String userId = ((CozeLlmConfig)this.config).getDefaultUserId();
        String conversationId = ((CozeLlmConfig)this.config).getDefaultConversationId();
        Map<String, String> customVariables = null;
        if (chatOptions instanceof CozeChatOptions) {
            CozeChatOptions options = (CozeChatOptions)chatOptions;
            botId = StringUtil.hasText((String)options.getBotId()) ? options.getBotId() : botId;
            userId = StringUtil.hasText((String)options.getUserId()) ? options.getUserId() : userId;
            conversationId = StringUtil.hasText((String)options.getConversationId()) ? options.getConversationId() : conversationId;
            customVariables = options.getCustomVariables();
        }
        String payload = CozeLlmUtil.promptToPayload(prompt, botId, userId, customVariables, stream);
        String url = ((CozeLlmConfig)this.config).getEndpoint() + ((CozeLlmConfig)this.config).getChatApi();
        if (StringUtil.hasText((String)conversationId)) {
            url = url + "?conversation_id=" + conversationId;
        }
        String response = this.httpClient.post(url, this.buildHeader(), payload);
        if (((CozeLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (stream) {
            this.handleStreamResponse(response, listener);
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        String code = jsonObject.getString("code");
        String error = jsonObject.getString("msg");
        CozeChatContext cozeChat = (CozeChatContext)((Object)jsonObject.getObject("data", CozeChatContext.class));
        if (!error.isEmpty() && !Objects.equals(code, "0")) {
            if (cozeChat == null) {
                cozeChat = new CozeChatContext();
                cozeChat.setLlm((Llm)this);
                cozeChat.setResponse(response);
            }
            listener.onFailure(cozeChat, new Throwable(error));
            listener.onStop(cozeChat);
            return;
        }
        if (cozeChat != null) {
            cozeChat.setLlm((Llm)this);
            cozeChat.setResponse(response);
        }
        int attemptCount = 0;
        boolean isCompleted = false;
        int maxAttempts = 20;
        while (attemptCount < maxAttempts && !isCompleted) {
            ++attemptCount;
            try {
                cozeChat = this.checkStatus(cozeChat);
                listener.onMessage(cozeChat);
                isCompleted = Objects.equals(cozeChat.getStatus(), "completed");
                if (isCompleted || attemptCount == maxAttempts) {
                    listener.onStop(cozeChat);
                    break;
                }
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                listener.onFailure(cozeChat, e.getCause());
                listener.onStop(cozeChat);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void handleStreamResponse(String response, CozeRequestListener listener) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.getBytes(Charset.defaultCharset()));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.defaultCharset()));
        CozeChatContext context = new CozeChatContext();
        context.setLlm((Llm)this);
        ArrayList<AiMessage> messageList = new ArrayList<AiMessage>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty() || !line.startsWith("data:") || line.contains("[DONE]")) continue;
                line = line.substring(5);
                JSONObject data = JSON.parseObject((String)line);
                String status = data.getString("status");
                String type = data.getString("type");
                if ("completed".equalsIgnoreCase(status)) {
                    context = (CozeChatContext)((Object)JSON.parseObject((String)line, CozeChatContext.class));
                    context.setResponse(line);
                    listener.onStop(context);
                    continue;
                }
                if (!"answer".equalsIgnoreCase(type)) continue;
                AiMessage message = new AiMessage();
                message.setContent(data.getString("content"));
                messageList.add(message);
            }
            if (!messageList.isEmpty()) {
                messageList.remove(messageList.size() - 1);
                for (AiMessage m : messageList) {
                    context.setMessage(m);
                    listener.onMessage(context);
                    Thread.sleep(10L);
                }
            }
        }
        catch (IOException ex) {
            listener.onFailure(context, ex.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private CozeChatContext checkStatus(CozeChatContext cozeChat) {
        String chatId = cozeChat.getId();
        String conversationId = cozeChat.getConversationId();
        String url = String.format("%s/v3/chat/retrieve?chat_id=%s&conversation_id=%s", ((CozeLlmConfig)this.config).getEndpoint(), chatId, conversationId);
        String response = this.httpClient.get(url, this.buildHeader());
        JSONObject resObj = JSON.parseObject((String)response);
        return (CozeChatContext)((Object)resObj.getObject("data", CozeChatContext.class));
    }

    private JSONArray fetchMessageList(CozeChatContext cozeChat) {
        String chatId = cozeChat.getId();
        String conversationId = cozeChat.getConversationId();
        String endpoint = ((CozeLlmConfig)this.config).getEndpoint();
        String url = String.format("%s/v3/chat/message/list?chat_id=%s&conversation_id=%s", endpoint, chatId, conversationId);
        String response = this.httpClient.get(url, this.buildHeader());
        JSONObject jsonObject = JSON.parseObject((String)response);
        String code = jsonObject.getString("code");
        String error = jsonObject.getString("msg");
        JSONArray messageList = jsonObject.getJSONArray("data");
        if (!error.isEmpty() && !Objects.equals(code, "0")) {
            return null;
        }
        return messageList;
    }

    public AiMessage getChatAnswer(CozeChatContext cozeChat) {
        JSONObject answer;
        JSONArray messageList = this.fetchMessageList(cozeChat);
        if (messageList == null || messageList.isEmpty()) {
            return null;
        }
        List objects = messageList.stream().map(JSONObject.class::cast).filter(obj -> "answer".equals(obj.getString("type"))).collect(Collectors.toList());
        JSONObject jSONObject = answer = !objects.isEmpty() ? (JSONObject)objects.get(0) : null;
        if (answer != null) {
            answer.put("usage", (Object)cozeChat.getUsage());
            answer.put("content", (Object)answer.getString("content"));
            return (AiMessage)this.aiMessageParser.parse((Object)answer);
        }
        return null;
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        final CountDownLatch latch = new CountDownLatch(1);
        final Message[] messages = new Message[1];
        final String[] responses = new String[1];
        final Throwable[] failureThrowable = new Throwable[1];
        this.botChat(prompt, new CozeRequestListener(){

            @Override
            public void onMessage(CozeChatContext context) {
                boolean isCompleted = Objects.equals(context.getStatus(), "completed");
                if (isCompleted) {
                    AiMessage answer = CozeLlm.this.getChatAnswer(context);
                    messages[0] = answer;
                    responses[0] = context.getResponse();
                }
            }

            @Override
            public void onFailure(CozeChatContext context, Throwable throwable) {
                failureThrowable[0] = throwable;
                responses[0] = context.getResponse();
                latch.countDown();
            }

            @Override
            public void onStop(CozeChatContext context) {
                latch.countDown();
            }
        }, options, false);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        AiMessageResponse response = new AiMessageResponse(prompt, responses[0], (AiMessage)messages[0]);
        if (messages[0] == null || failureThrowable[0] != null) {
            response.setError(true);
            if (failureThrowable[0] != null) {
                response.setErrorMessage(failureThrowable[0].getMessage());
            }
        }
        return response;
    }

    public void chatStream(final Prompt prompt, final StreamResponseListener listener, ChatOptions options) {
        this.botChat(prompt, new CozeRequestListener(){

            @Override
            public void onMessage(CozeChatContext context) {
                AiMessageResponse response = new AiMessageResponse(prompt, context.getResponse(), context.getMessage());
                listener.onMessage((ChatContext)context, response);
            }

            @Override
            public void onFailure(CozeChatContext context, Throwable throwable) {
                listener.onFailure((ChatContext)context, throwable);
            }

            @Override
            public void onStop(CozeChatContext context) {
                listener.onStop((ChatContext)context);
            }
        }, options, true);
    }
}

