/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.gitee;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.gitee.GiteeAiLlmConfig;
import com.agentsflex.llm.gitee.GiteeAiLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.function.Consumer;

public class GiteeAiLlm
extends BaseLlm<GiteeAiLlmConfig> {
    private final HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = GiteeAiLlmUtil.getAiMessageParser(false);
    public AiMessageParser streamMessageParser = GiteeAiLlmUtil.getAiMessageParser(true);

    public GiteeAiLlm(GiteeAiLlmConfig config) {
        super((LlmConfig)config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((GiteeAiLlmConfig)this.getConfig()).getApiKey());
        Consumer headersConfig = ((GiteeAiLlmConfig)this.config).getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(headers);
        }
        String payload = GiteeAiLlmUtil.promptToPayload(prompt, (GiteeAiLlmConfig)this.config, options, false);
        if (((GiteeAiLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>send payload:" + payload));
        }
        String endpoint = ((GiteeAiLlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/api/serverless/" + ((GiteeAiLlmConfig)this.config).getModel() + "/chat/completions", headers, payload);
        if (((GiteeAiLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((GiteeAiLlmConfig)this.getConfig()).getApiKey());
        String payload = GiteeAiLlmUtil.promptToPayload(prompt, (GiteeAiLlmConfig)this.config, options, true);
        String endpoint = ((GiteeAiLlmConfig)this.config).getEndpoint();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.streamMessageParser);
        llmClient.start(endpoint + "/api/serverless/" + ((GiteeAiLlmConfig)this.config).getModel() + "/chat/completions", headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((GiteeAiLlmConfig)this.getConfig()).getApiKey());
        String payload = Maps.of((String)"inputs", (Object)document.getContent()).toJSON();
        String endpoint = ((GiteeAiLlmConfig)this.config).getEndpoint();
        String embeddingModel = options.getModelOrDefault(((GiteeAiLlmConfig)this.config).getDefaultEmbeddingModal());
        String response = this.httpClient.post(endpoint + "/api/serverless/" + embeddingModel + "/embeddings", headers, payload);
        if (((GiteeAiLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return null;
        }
        VectorData vectorData = new VectorData();
        double[] embedding = (double[])JSONObject.parseObject((String)response, double[].class);
        vectorData.setVector(embedding);
        return vectorData;
    }
}

