/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.moonshot;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.moonshot.MoonshotLlmConfig;
import com.agentsflex.llm.moonshot.MoonshotLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;

public class MoonshotLlm
extends BaseLlm<MoonshotLlmConfig> {
    HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = MoonshotLlmUtil.getAiMessageParser(false);
    public AiMessageParser aiStreamMessageParser = MoonshotLlmUtil.getAiMessageParser(true);

    public MoonshotLlm(MoonshotLlmConfig config) {
        super((LlmConfig)config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((MoonshotLlmConfig)this.config).getApiKey());
        String endpoint = ((MoonshotLlmConfig)this.config).getEndpoint();
        String payload = MoonshotLlmUtil.promptToPayload(prompt, (MoonshotLlmConfig)this.config, false, options);
        String response = this.httpClient.post(endpoint + "/v1/chat/completions", headers, payload);
        if (((MoonshotLlmConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((MoonshotLlmConfig)this.getConfig()).getApiKey());
        String payload = MoonshotLlmUtil.promptToPayload(prompt, (MoonshotLlmConfig)this.config, true, options);
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, this.aiStreamMessageParser);
        String endpoint = ((MoonshotLlmConfig)this.config).getEndpoint();
        llmClient.start(endpoint + "/v1/chat/completions", headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        throw new IllegalStateException("Moonshot can not support embedding");
    }
}

