/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.redis;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.store.redis.RedisVectorStoreConfig;
import com.alibaba.fastjson.JSON;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.search.FTCreateParams;
import redis.clients.jedis.search.IndexDataType;
import redis.clients.jedis.search.Query;
import redis.clients.jedis.search.SearchResult;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.search.schemafields.TextField;
import redis.clients.jedis.search.schemafields.VectorField;

public class RedisVectorStore
extends DocumentStore {
    private final RedisVectorStoreConfig config;
    private final JedisPooled jedis;
    private final Set<String> redisIndexesCache = new HashSet<String>();
    private static final Logger logger = LoggerFactory.getLogger(RedisVectorStore.class);

    public RedisVectorStore(RedisVectorStoreConfig config) {
        this.config = config;
        this.jedis = new JedisPooled(URI.create(config.getUri()));
    }

    private void createSchemaIfNecessary(String indexName) {
        if (this.redisIndexesCache.contains(indexName)) {
            return;
        }
        Set existIndexes = this.jedis.ftList();
        if (existIndexes != null && existIndexes.contains(indexName)) {
            this.redisIndexesCache.add(indexName);
            return;
        }
        FTCreateParams ftCreateParams = FTCreateParams.createParams().on(IndexDataType.JSON).addPrefix(this.getPrefix(indexName));
        this.jedis.ftCreate(indexName, ftCreateParams, this.schemaFields());
        this.redisIndexesCache.add(indexName);
    }

    private Iterable<SchemaField> schemaFields() {
        HashMap<String, Object> vectorAttrs = new HashMap<String, Object>();
        vectorAttrs.put("DISTANCE_METRIC", "COSINE");
        vectorAttrs.put("TYPE", "FLOAT32");
        vectorAttrs.put("DIM", this.getEmbeddingModel().dimensions());
        ArrayList<SchemaField> fields = new ArrayList<SchemaField>();
        fields.add((SchemaField)TextField.of((String)this.jsonPath("text")).as("text").weight(1.0));
        fields.add((SchemaField)VectorField.builder().fieldName(this.jsonPath("vector")).algorithm(VectorField.VectorAlgorithm.HNSW).attributes(vectorAttrs).as("vector").build());
        return fields;
    }

    private String jsonPath(String field) {
        return "$." + field;
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        String indexName = this.createIndexName(options);
        if (StringUtil.noText((String)indexName)) {
            throw new IllegalStateException("IndexName is null or blank. please config the \"defaultCollectionName\" or store with designative collectionName.");
        }
        this.createSchemaIfNecessary(indexName);
        try (Pipeline pipeline = this.jedis.pipelined();){
            for (Document document : documents) {
                HashMap<String, Object> fields = new HashMap<String, Object>();
                fields.put("text", document.getContent());
                fields.put("vector", document.getVector());
                String key = this.getPrefix(indexName) + document.getId();
                pipeline.jsonSetWithEscape(key, Path2.of((String)"$"), fields);
            }
            List objects = pipeline.syncAndReturnAll();
            for (Object object : objects) {
                if (object.equals("OK")) continue;
                logger.error("Could not store document: {}", object);
                StoreResult storeResult = StoreResult.fail();
                return storeResult;
            }
        }
        return StoreResult.successWithIds(documents);
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        String indexName = this.createIndexName(options);
        try (Pipeline pipeline = this.jedis.pipelined();){
            for (Object id : ids) {
                String key = this.getPrefix(indexName) + id;
                pipeline.jsonDel(key);
            }
            List objects = pipeline.syncAndReturnAll();
            for (Object object : objects) {
                if (object.equals(1L)) continue;
                logger.error("Could not delete document: {}", object);
                StoreResult storeResult = StoreResult.fail();
                return storeResult;
            }
        }
        return StoreResult.success();
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        return this.storeInternal(documents, options);
    }

    public List<Document> searchInternal(SearchWrapper wrapper, StoreOptions options) {
        String indexName = this.createIndexName(options);
        if (StringUtil.noText((String)indexName)) {
            throw new IllegalStateException("IndexName is null or blank. please config the \"defaultCollectionName\" or store with designative collectionName.");
        }
        this.createSchemaIfNecessary(indexName);
        byte[] vectorBytes = new byte[wrapper.getVector().length * 4];
        FloatBuffer floatBuffer = ByteBuffer.wrap(vectorBytes).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        double[] dArray = wrapper.getVector();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double v = dArray[i];
            floatBuffer.put(v.floatValue());
        }
        Query query = new Query("*=>[KNN " + wrapper.getMaxResults() + " @vector $BLOB AS score]").addParam("BLOB", (Object)vectorBytes).returnFields(new String[]{"text", "vector", "score"}).setSortBy("score", false).limit(Integer.valueOf(0), wrapper.getMaxResults()).dialect(2);
        int keyPrefixLen = this.getPrefix(indexName).length();
        SearchResult searchResult = this.jedis.ftSearch(indexName, query);
        List searchDocuments = searchResult.getDocuments();
        ArrayDeque documents = new ArrayDeque(searchDocuments.size());
        for (redis.clients.jedis.search.Document document : searchDocuments) {
            String id = document.getId().substring(keyPrefixLen);
            Document doc = new Document();
            doc.setId((Object)id);
            doc.setContent(document.getString("text"));
            Object vector = document.get("vector");
            if (vector != null) {
                double[] doubles = (double[])JSON.parseObject((String)vector.toString(), double[].class);
                doc.setVector(doubles);
            }
            doc.addMetadata("score", (Object)Float.valueOf(1.0f - this.similarityScore(document)));
            documents.add(doc);
        }
        return documents;
    }

    private float similarityScore(redis.clients.jedis.search.Document doc) {
        return (2.0f - Float.parseFloat(doc.getString("score"))) / 2.0f;
    }

    private String createIndexName(StoreOptions options) {
        return options.getCollectionNameOrDefault(this.config.getDefaultCollectionName());
    }

    @NotNull
    private String getPrefix(String indexName) {
        return this.config.getStorePrefix() + indexName + ":";
    }
}

