/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.vectorex;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.store.DocumentStore;
import com.agentsflex.core.store.SearchWrapper;
import com.agentsflex.core.store.StoreOptions;
import com.agentsflex.core.store.StoreResult;
import com.agentsflex.core.util.VectorUtil;
import com.agentsflex.store.vectorex.VectoRexStoreConfig;
import io.github.javpower.vectorexclient.VectorRexClient;
import io.github.javpower.vectorexclient.builder.QueryBuilder;
import io.github.javpower.vectorexclient.entity.MetricType;
import io.github.javpower.vectorexclient.entity.ScalarField;
import io.github.javpower.vectorexclient.entity.VectorFiled;
import io.github.javpower.vectorexclient.req.CollectionDataAddReq;
import io.github.javpower.vectorexclient.req.CollectionDataDelReq;
import io.github.javpower.vectorexclient.req.VectoRexCollectionReq;
import io.github.javpower.vectorexclient.res.DbData;
import io.github.javpower.vectorexclient.res.ServerResponse;
import io.github.javpower.vectorexclient.res.VectorSearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectoRexStore
extends DocumentStore {
    private final VectoRexStoreConfig config;
    private final VectorRexClient client;
    private final String defaultCollectionName;
    private boolean isCreateCollection = false;
    private static final Logger logger = LoggerFactory.getLogger(VectoRexStore.class);

    public VectoRexStore(VectoRexStoreConfig config) {
        this.config = config;
        this.defaultCollectionName = config.getDefaultCollectionName();
        this.client = new VectorRexClient(config.getUri(), config.getUsername(), config.getPassword());
    }

    public StoreResult storeInternal(List<Document> documents, StoreOptions options) {
        ArrayList data = new ArrayList();
        for (Document doc : documents) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", String.valueOf(doc.getId()));
            hashMap.put("content", doc.getContent());
            hashMap.put("vector", VectorUtil.toFloatList((double[])doc.getVector()));
            data.add(hashMap);
        }
        String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
        if (this.config.isAutoCreateCollection() && !this.isCreateCollection) {
            ServerResponse collections = this.client.getCollections();
            if (collections.getData() == null || ((List)collections.getData()).stream().noneMatch(e -> e.getCollectionName().equals(collectionName))) {
                this.createCollection(collectionName);
            } else {
                this.isCreateCollection = true;
            }
        }
        for (Map map : data) {
            CollectionDataAddReq req = CollectionDataAddReq.builder().collectionName(collectionName).metadata(map).build();
            this.client.addCollectionData(req);
        }
        return StoreResult.successWithIds(documents);
    }

    private Boolean createCollection(String collectionName) {
        ArrayList<ScalarField> scalarFields = new ArrayList<ScalarField>();
        ScalarField id = ScalarField.builder().name("id").isPrimaryKey(Boolean.valueOf(true)).build();
        ScalarField content = ScalarField.builder().name("content").isPrimaryKey(Boolean.valueOf(false)).build();
        scalarFields.add(id);
        scalarFields.add(content);
        ArrayList<VectorFiled> vectorFiles = new ArrayList<VectorFiled>();
        VectorFiled vector = VectorFiled.builder().name("vector").metricType(MetricType.FLOAT_COSINE_DISTANCE).dimensions(Integer.valueOf(this.getEmbeddingModel().dimensions())).build();
        vectorFiles.add(vector);
        ServerResponse response = this.client.createCollection(VectoRexCollectionReq.builder().collectionName(collectionName).scalarFields(scalarFields).vectorFileds(vectorFiles).build());
        return response.isSuccess();
    }

    public StoreResult deleteInternal(Collection<?> ids, StoreOptions options) {
        for (Object id : ids) {
            CollectionDataDelReq req = CollectionDataDelReq.builder().collectionName(options.getCollectionNameOrDefault(this.defaultCollectionName)).id((String)id).build();
            ServerResponse response = this.client.deleteCollectionData(req);
            if (response.isSuccess()) continue;
            return StoreResult.fail();
        }
        return StoreResult.success();
    }

    public List<Document> searchInternal(SearchWrapper searchWrapper, StoreOptions options) {
        ServerResponse response = this.client.queryCollectionData(QueryBuilder.lambda((String)options.getCollectionNameOrDefault(this.defaultCollectionName)).vector("vector", Collections.singletonList(VectorUtil.toFloatList((double[])searchWrapper.getVector()))).topK(searchWrapper.getMaxResults()));
        if (!response.isSuccess()) {
            logger.error("Error searching in VectoRex", (Object)response.getMsg());
            return Collections.emptyList();
        }
        List data = (List)response.getData();
        ArrayList<Document> documents = new ArrayList<Document>();
        for (VectorSearchResult result : data) {
            DbData dd = result.getData();
            Map metadata = dd.getMetadata();
            Document doc = new Document();
            doc.setId((Object)result.getId());
            doc.setContent((String)metadata.get("content"));
            Object vectorObj = metadata.get("vector");
            if (vectorObj instanceof List) {
                doc.setVector(VectorUtil.convertToVector((List)((List)vectorObj)));
            }
            documents.add(doc);
        }
        return documents;
    }

    public StoreResult updateInternal(List<Document> documents, StoreOptions options) {
        if (documents == null || documents.isEmpty()) {
            return StoreResult.success();
        }
        ArrayList data = new ArrayList();
        for (Document doc : documents) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", String.valueOf(doc.getId()));
            hashMap.put("content", doc.getContent());
            hashMap.put("vector", VectorUtil.toFloatList((double[])doc.getVector()));
            data.add(hashMap);
        }
        String collectionName = options.getCollectionNameOrDefault(this.defaultCollectionName);
        for (Map map : data) {
            CollectionDataAddReq req = CollectionDataAddReq.builder().collectionName(collectionName).metadata(map).build();
            this.client.updateCollectionData(req);
        }
        return StoreResult.successWithIds(documents);
    }

    public VectorRexClient getClient() {
        return this.client;
    }
}

