/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.supports.scan;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.cache.EndPointInfoCache;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.rpc.supports.scan.EndPointInfo;
import com.aizuda.snailjob.client.common.rpc.supports.scan.SnailEndPointScanner;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class SnailEndPointRegistrar
implements Lifecycle {
    private final SnailEndPointScanner snailEndPointScanner;

    @Override
    public void start() {
        List<EndPointInfo> endPointInfos = this.snailEndPointScanner.doScan();
        for (EndPointInfo endPointInfo : endPointInfos) {
            if (EndPointInfoCache.isExisted(endPointInfo.getPath(), endPointInfo.getRequestMethod())) {
                throw new SnailJobClientException("Duplicate endpoint path: {}", (Object)endPointInfo.getPath());
            }
            EndPointInfoCache.put(endPointInfo);
        }
    }

    @Override
    public void close() {
    }

    public SnailEndPointRegistrar(SnailEndPointScanner snailEndPointScanner) {
        this.snailEndPointScanner = snailEndPointScanner;
    }
}

