/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.event.SnailChannelReconnectEvent;
import com.aizuda.snailjob.client.common.rpc.client.GrpcChannel;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RpcTypeEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ConnectivityState;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SnailJobGrpcClient
implements Lifecycle {
    private ManagedChannel channel;
    private final SnailJobProperties snailJobProperties;
    private static final ScheduledExecutorService SCHEDULE_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sj-client-check"));

    @Override
    public void start() {
        if (RpcTypeEnum.GRPC != this.snailJobProperties.getRpcType()) {
            return;
        }
        this.channel = this.connection();
        GrpcChannel.setChannel(this.channel);
        SnailJobLog.LOCAL.info("grpc client started connect to server", new Object[0]);
        SCHEDULE_EXECUTOR.scheduleAtFixedRate(() -> {
            ConnectivityState state = this.channel.getState(true);
            if (state == ConnectivityState.TRANSIENT_FAILURE) {
                try {
                    SnailSpringContext.getContext().publishEvent((ApplicationEvent)new SnailChannelReconnectEvent());
                }
                catch (Exception e) {
                    SnailJobLog.LOCAL.error("reconnect error ", new Object[]{e});
                }
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdownNow();
        }
    }

    public ManagedChannel connection() {
        SnailJobProperties.RpcClientProperties clientRpc = this.snailJobProperties.getClientRpc();
        String serverHost = GrpcChannel.getServerHost();
        return ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)serverHost, (int)GrpcChannel.getServerPort()).executor((Executor)this.createGrpcExecutor(serverHost))).decompressorRegistry(DecompressorRegistry.getDefaultInstance())).maxInboundMessageSize(clientRpc.getMaxInboundMessageSize()).keepAliveTime(clientRpc.getKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(clientRpc.getKeepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS).usePlaintext().enableRetry()).maxRetryAttempts(16)).build();
    }

    private ThreadPoolExecutor createGrpcExecutor(String serverIp) {
        SnailJobProperties.RpcClientProperties clientRpc = this.snailJobProperties.getClientRpc();
        SnailJobProperties.ThreadPoolConfig threadPool = clientRpc.getClientTp();
        serverIp = serverIp.replaceAll("%", "-");
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(threadPool.getCorePoolSize(), threadPool.getMaximumPoolSize(), threadPool.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(threadPool.getQueueCapacity()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("snail-job-grpc-client-executor-" + serverIp + "-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    @Generated
    public SnailJobGrpcClient(SnailJobProperties snailJobProperties) {
        this.snailJobProperties = snailJobProperties;
    }
}

