/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.handler.update;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.job.core.enums.TriggerTypeEnum;
import com.aizuda.snailjob.client.job.core.handler.AbstractParamsHandler;
import com.aizuda.snailjob.client.job.core.handler.update.Update;
import com.aizuda.snailjob.client.job.core.util.ValidatorUtils;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;

public abstract class UpdateHandler<H>
extends AbstractParamsHandler<H, Boolean> {
    public UpdateHandler(JobTaskTypeEnum typeEnum, Long jobId) {
        super(typeEnum);
        this.setId(jobId);
    }

    @Override
    protected void afterExecute(Boolean aBoolean) {
    }

    @Override
    protected void beforeExecute() {
        if (this.getReqDTO().getTriggerType().intValue() == TriggerTypeEnum.WORK_FLOW.getType()) {
            this.setTriggerInterval("*");
        }
    }

    @Override
    protected Boolean doExecute() {
        Result<Object> result = client.updateJob(this.getReqDTO());
        Assert.isTrue((StatusEnum.YES.getStatus().intValue() == result.getStatus() ? 1 : 0) != 0, () -> new SnailJobClientException(result.getMessage()));
        return (Boolean)result.getData();
    }

    @Override
    protected Pair<Boolean, String> checkRequest() {
        return ValidatorUtils.validateEntity(Update.class, (Object)this.getReqDTO());
    }
}

