/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.dialect.log4j2;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.log.dialect.AbstractLog;
import com.aizuda.snailjob.common.log.factory.LogFactory;
import org.apache.log4j.MDC;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log4j2Log
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Logger logger;

    public Log4j2Log(Logger logger) {
        this.logger = logger;
    }

    public Log4j2Log(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public Log4j2Log(String name) {
        this(LogManager.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.TRACE, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.DEBUG, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.INFO, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.WARN, remote, fqcn, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(Level.ERROR, remote, fqcn, format, arguments);
    }

    @Override
    public void log(com.aizuda.snailjob.common.log.level.Level level, Boolean remote, String fqcn, String format, Object ... arguments) {
        this.logIfEnabled(switch (level) {
            case com.aizuda.snailjob.common.log.level.Level.TRACE -> Level.TRACE;
            case com.aizuda.snailjob.common.log.level.Level.DEBUG -> Level.DEBUG;
            case com.aizuda.snailjob.common.log.level.Level.INFO -> Level.INFO;
            case com.aizuda.snailjob.common.log.level.Level.WARN -> Level.WARN;
            case com.aizuda.snailjob.common.log.level.Level.ERROR -> Level.ERROR;
            default -> throw new Error(StrUtil.format((CharSequence)"Can not identify level: {}", (Object[])new Object[]{level}));
        }, remote, fqcn, format, arguments);
    }

    private void logIfEnabled(Level level, Boolean remote, String fqcn, String msgTemplate, Object ... arguments) {
        if (this.logger.isEnabled(level)) {
            if (remote.booleanValue()) {
                MDC.put((String)"remote", (Object)remote.toString());
            }
            if (this.logger instanceof AbstractLogger) {
                ((AbstractLogger)this.logger).logIfEnabled(fqcn, level, null, StrUtil.format((CharSequence)msgTemplate, (Object[])arguments), LogFactory.extractThrowable(arguments));
            } else {
                this.logger.log(level, StrUtil.format((CharSequence)msgTemplate, (Object[])arguments), LogFactory.extractThrowable(arguments));
            }
        }
    }
}

