/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.factory;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.caller.CallerUtil;
import cn.hutool.core.map.SafeConcurrentHashMap;
import cn.hutool.core.util.ServiceLoaderUtil;
import com.aizuda.snailjob.common.log.dialect.Log;
import com.aizuda.snailjob.common.log.dialect.console.ConsoleLogFactory;
import com.aizuda.snailjob.common.log.dialect.jdk.JdkLogFactory;
import com.aizuda.snailjob.common.log.factory.GlobalLogFactory;
import java.net.URL;
import java.util.Map;

public abstract class LogFactory {
    protected String name;
    private final Map<Object, Log> logCache;

    public LogFactory(String name) {
        this.name = name;
        this.logCache = new SafeConcurrentHashMap();
    }

    public String getName() {
        return this.name;
    }

    public Log getLog(String name) {
        return this.logCache.computeIfAbsent(name, o -> this.createLog((String)o));
    }

    public Log getLog(Class<?> clazz) {
        return this.logCache.computeIfAbsent(clazz, o -> this.createLog((Class)o));
    }

    public abstract Log createLog(String var1);

    public abstract Log createLog(Class<?> var1);

    protected void checkLogExist(Class<?> logClassName) {
    }

    public static LogFactory getCurrentLogFactory() {
        return GlobalLogFactory.get();
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        return GlobalLogFactory.set(logFactoryClass);
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        return GlobalLogFactory.set(logFactory);
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(CallerUtil.getCallerCaller());
    }

    public static LogFactory create() {
        LogFactory factory = LogFactory.doCreate();
        factory.getLog(LogFactory.class);
        return factory;
    }

    private static LogFactory doCreate() {
        LogFactory factory = (LogFactory)ServiceLoaderUtil.loadFirstAvailable(LogFactory.class);
        if (null != factory) {
            return factory;
        }
        URL url = ResourceUtil.getResource((String)"logging.properties");
        return null != url ? new JdkLogFactory() : new ConsoleLogFactory();
    }

    public static Throwable extractThrowable(Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return null;
        }
        Object lastEntry = arguments[arguments.length - 1];
        if (lastEntry instanceof Throwable) {
            return (Throwable)lastEntry;
        }
        return null;
    }
}

