/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.strategy;

import com.aizuda.snailjob.common.log.dialect.Log;
import com.aizuda.snailjob.common.log.factory.LogFactory;
import com.aizuda.snailjob.common.log.lang.LogCaller;
import com.aizuda.snailjob.common.log.level.Level;

public abstract class AbstractLog {
    private static final String FQCN = AbstractLog.class.getName();
    private Boolean isRemote = Boolean.FALSE;

    public Boolean getRemote() {
        return this.isRemote;
    }

    protected void setRemote(Boolean remote) {
        this.isRemote = remote;
    }

    public void trace(String format, Object ... arguments) {
        this.trace(LogFactory.get(LogCaller.getCallerCaller()), format, arguments);
    }

    public void trace(Log log, String format, Object ... arguments) {
        log.trace(this.isRemote, FQCN, format, arguments);
    }

    public void debug(String format, Object ... arguments) {
        this.debug(LogFactory.get(LogCaller.getCallerCaller()), format, arguments);
    }

    public void debug(Log log, String format, Object ... arguments) {
        log.debug(this.isRemote, FQCN, format, arguments);
    }

    public void info(String format, Object ... arguments) {
        this.info(LogFactory.get(LogCaller.getCallerCaller()), format, arguments);
    }

    public void info(Log log, String format, Object ... arguments) {
        log.info(this.isRemote, FQCN, format, arguments);
    }

    public void warn(String format, Object ... arguments) {
        this.warn(LogFactory.get(LogCaller.getCallerCaller()), format, arguments);
    }

    public void warn(Log log, String format, Object ... arguments) {
        log.warn(this.isRemote, FQCN, format, arguments);
    }

    public void error(Throwable e) {
        this.error(LogFactory.get(LogCaller.getCallerCaller()), e);
    }

    public void error(String format, Object ... arguments) {
        this.error(LogFactory.get(LogCaller.getCallerCaller()), format, arguments);
    }

    public void error(Log log, Throwable e) {
        log.error((Boolean)false, e);
    }

    public void error(Log log, String format, Object ... arguments) {
        log.error(this.isRemote, FQCN, format, arguments);
    }

    public void log(Level level, Boolean remote, String format, Object ... arguments) {
        LogFactory.get(LogCaller.getCallerCaller()).log(level, remote, FQCN, format, arguments);
    }
}

