/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.template.datasource.config;

import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.handler.InjectionMetaObjectHandler;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;
import com.aizuda.snailjob.template.datasource.utils.RequestDataHelper;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@ComponentScan(value={"com.aizuda.snailjob.template.datasource.**"})
@MapperScan(value={"com.aizuda.snailjob.template.datasource.persistence.mapper"}, sqlSessionTemplateRef="sqlSessionTemplate")
public class SnailJobTemplateAutoConfiguration {
    private static final List<String> TABLES_WITH_PARTITION = Arrays.asList("sj_retry_task", "sj_retry_dead_letter");

    @Bean(value={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource, Environment environment, MybatisPlusInterceptor mybatisPlusInterceptor, MybatisPlusProperties mybatisPlusProperties) throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        DbTypeEnum dbTypeEnum = DbUtils.getDbType();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] templateMapperResource = resolver.getResources("classpath*:/template/mapper/*.xml");
        Resource[] specificMapperResource = resolver.getResources(MessageFormat.format("classpath*:/{0}/mapper/*.xml", dbTypeEnum.getDb()));
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.addAll(List.of(templateMapperResource));
        resources.addAll(List.of(specificMapperResource));
        factoryBean.setMapperLocations(resources.toArray(new Resource[0]));
        factoryBean.setPlugins(new Interceptor[]{mybatisPlusInterceptor});
        factoryBean.setTypeAliasesPackage(mybatisPlusProperties.getTypeAliasesPackage());
        GlobalConfig globalConfig = mybatisPlusProperties.getGlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new InjectionMetaObjectHandler());
        factoryBean.setGlobalConfig(mybatisPlusProperties.getGlobalConfig());
        return factoryBean.getObject();
    }

    @Bean(value={"sqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(Environment environment) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        String tablePrefix = Optional.ofNullable(environment.getProperty("mybatis-plus.global-config.db-config.table-prefix")).orElse("");
        interceptor.addInnerInterceptor((InnerInterceptor)this.dynamicTableNameInnerInterceptor(tablePrefix));
        DbTypeEnum dbTypeEnum = DbUtils.getDbType();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(dbTypeEnum.getMpDbType()));
        return interceptor;
    }

    public DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor(String tablePrefix) {
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
        dynamicTableNameInnerInterceptor.setTableNameHandler((sql, tableName) -> {
            if (TABLES_WITH_PARTITION.contains(tableName)) {
                Integer partition = RequestDataHelper.getPartition();
                RequestDataHelper.remove();
                tableName = (String)tableName + "_" + partition;
            }
            return ((String)tableName).startsWith(tablePrefix) ? tableName : tablePrefix + (String)tableName;
        });
        return dynamicTableNameInnerInterceptor;
    }
}

