/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.appender;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.dto.LogContentDTO;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.server.common.LogStorage;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.dto.LogMetaDTO;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.common.log.LogStorageFactory;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.MDC;

public class SnailJobServerLogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    protected void append(E eventObject) {
        LoggingEvent event;
        block13: {
            block12: {
                if (!(eventObject instanceof LoggingEvent)) break block12;
                event = (LoggingEvent)eventObject;
                if (!Objects.isNull(MDC.getMDCAdapter().get("remote"))) break block13;
            }
            return;
        }
        MDC.getMDCAdapter().remove("remote");
        event.prepareForDeferredProcessing();
        LogContentDTO logContentDTO = new LogContentDTO();
        logContentDTO.addLevelField(event.getLevel().levelStr);
        logContentDTO.addThreadField(event.getThreadName());
        logContentDTO.addLocationField(this.getLocationField(event));
        logContentDTO.addThrowableField(this.getThrowableField(event));
        logContentDTO.addHostField(NetUtil.getLocalIpStr());
        logContentDTO.addPortField(Integer.valueOf(((SystemProperties)SnailSpringContext.getBean(SystemProperties.class)).getNettyPort()));
        LogMetaDTO logMetaDTO = null;
        try {
            String patternString = "<\\|>(.*?)<\\|>";
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(event.getFormattedMessage());
            while (matcher.find()) {
                String extractedData = matcher.group(1);
                if (StrUtil.isBlank((CharSequence)extractedData)) continue;
                JsonNode jsonNode = JsonUtil.toJson((String)extractedData);
                if (!jsonNode.has("logType")) {
                    return;
                }
                String name = jsonNode.get("logType").asText();
                if (LogTypeEnum.RETRY.equals((Object)LogTypeEnum.valueOf((String)name))) {
                    logMetaDTO = (LogMetaDTO)JsonUtil.parseObject((String)extractedData, RetryLogMetaDTO.class);
                } else if (LogTypeEnum.JOB.equals((Object)LogTypeEnum.valueOf((String)name))) {
                    logMetaDTO = (LogMetaDTO)JsonUtil.parseObject((String)extractedData, JobLogMetaDTO.class);
                } else {
                    throw new IllegalArgumentException("logType is not support");
                }
                String message = event.getFormattedMessage().replaceFirst(patternString, "");
                logContentDTO.addMessageField(message);
                logContentDTO.addTimeStamp(Optional.ofNullable(logMetaDTO.getTimestamp()).orElse(event.getTimeStamp()));
                break;
            }
            if (Objects.isNull(logMetaDTO)) {
                return;
            }
            this.saveLog(logContentDTO, logMetaDTO);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("\u65e5\u5fd7\u89e3\u6790\u5931\u8d25. msg:[{}]", new Object[]{event.getFormattedMessage(), e});
        }
    }

    private void saveLog(LogContentDTO logContentDTO, LogMetaDTO logMetaDTO) {
        LogStorage logStorage = LogStorageFactory.get(logMetaDTO.getLogType());
        if (Objects.nonNull(logStorage)) {
            logStorage.storage(logContentDTO, logMetaDTO);
        }
    }

    private String getThrowableField(LoggingEvent event) {
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            Object throwable = this.getExceptionInfo(iThrowableProxy);
            throwable = (String)throwable + this.formatThrowable(event.getThrowableProxy().getStackTraceElementProxyArray());
            return throwable;
        }
        return null;
    }

    private String getLocationField(LoggingEvent event) {
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            return caller[0].toString();
        }
        return null;
    }

    private String formatThrowable(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s + ": " + message : s;
    }
}

