/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.enums;

import com.aizuda.snailjob.template.datasource.enums.DbTypeEnum;
import com.aizuda.snailjob.template.datasource.utils.DbUtils;

public enum DashboardLineEnum {
    DAY("DAY"),
    WEEK("WEEK"),
    MONTH("MONTH"),
    YEAR("YEAR");

    private final String unit;

    public static DashboardLineEnum modeOf(String mode) {
        for (DashboardLineEnum value : DashboardLineEnum.values()) {
            if (!value.getUnit().equals(mode)) continue;
            return value;
        }
        return WEEK;
    }

    public static String dateFormat(String unit) {
        DashboardLineEnum mode = DashboardLineEnum.modeOf(unit);
        if (DbUtils.getDbType().equals((Object)DbTypeEnum.MYSQL)) {
            switch (mode) {
                case YEAR: {
                    return "%Y-%m";
                }
                case DAY: {
                    return "%H";
                }
            }
            return "%Y-%m-%d";
        }
        if (DbUtils.getDbType().equals((Object)DbTypeEnum.MARIADB)) {
            switch (mode) {
                case YEAR: {
                    return "%Y-%m";
                }
                case DAY: {
                    return "%H";
                }
            }
            return "%Y-%m-%d";
        }
        if (DbUtils.getDbType().equals((Object)DbTypeEnum.SQLSERVER)) {
            switch (mode) {
                case YEAR: {
                    return "yyyy-MM";
                }
                case DAY: {
                    return "HH";
                }
            }
            return "yyyy-MM-dd";
        }
        switch (mode) {
            case YEAR: {
                return "yyyy-MM";
            }
            case DAY: {
                return "HH24";
            }
        }
        return "yyyy-MM-dd";
    }

    private DashboardLineEnum(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }
}

