/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.callback;

import akka.actor.ActorRef;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.dto.RealJobExecutorDTO;
import com.aizuda.snailjob.server.job.task.enums.JobRetrySceneEnum;
import com.aizuda.snailjob.server.job.task.support.ClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackFactory;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractClientCallbackHandler
implements ClientCallbackHandler,
InitializingBean {
    @Autowired
    protected JobTaskMapper jobTaskMapper;
    @Autowired
    private JobMapper jobMapper;
    @Autowired
    private WorkflowTaskBatchMapper workflowTaskBatchMapper;

    @Override
    @Transactional
    public void callback(ClientCallbackContext context) {
        boolean needRetry = this.isNeedRetry(context);
        if (needRetry && this.updateRetryCount(context)) {
            Job job = context.getJob();
            JobTask jobTask = context.getJobTask();
            RealJobExecutorDTO realJobExecutor = JobTaskConverter.INSTANCE.toRealJobExecutorDTO(JobTaskConverter.INSTANCE.toJobExecutorContext(job), jobTask);
            realJobExecutor.setClientId(ClientInfoUtils.clientId((String)context.getClientInfo()));
            realJobExecutor.setWorkflowNodeId(context.getWorkflowNodeId());
            realJobExecutor.setWorkflowTaskBatchId(context.getWorkflowTaskBatchId());
            realJobExecutor.setRetryCount(jobTask.getRetryCount() + 1);
            realJobExecutor.setRetry(Boolean.TRUE);
            realJobExecutor.setRetryScene(context.getRetryScene());
            realJobExecutor.setTaskName(jobTask.getTaskName());
            if (StrUtil.isBlank((CharSequence)realJobExecutor.getWfContext())) {
                realJobExecutor.setWfContext(this.getWfContext(realJobExecutor.getWorkflowTaskBatchId()));
            }
            ActorRef actorRef = ActorGenerator.jobRealTaskExecutorActor();
            actorRef.tell((Object)realJobExecutor, actorRef);
            return;
        }
        this.doCallback(context);
    }

    private String getWfContext(Long workflowTaskBatchId) {
        if (Objects.isNull(workflowTaskBatchId)) {
            return null;
        }
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{WorkflowTaskBatch::getWfContext}).eq(WorkflowTaskBatch::getId, (Object)workflowTaskBatchId));
        if (Objects.isNull(workflowTaskBatch)) {
            return null;
        }
        return workflowTaskBatch.getWfContext();
    }

    private boolean updateRetryCount(ClientCallbackContext context) {
        JobTask updateJobTask = new JobTask();
        updateJobTask.setRetryCount(Integer.valueOf(1));
        String newClient = this.chooseNewClient(context);
        if (StrUtil.isNotBlank((CharSequence)newClient)) {
            updateJobTask.setClientInfo(newClient);
            context.setClientInfo(newClient);
        } else {
            context.setClientInfo(context.getJobTask().getClientInfo());
        }
        Job job = context.getJob();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(JobTask::getId, (Object)context.getTaskId());
        if (Objects.isNull(context.getRetryScene()) || Objects.equals(JobRetrySceneEnum.AUTO.getRetryScene(), context.getRetryScene())) {
            updateWrapper.lt(JobTask::getRetryCount, (Object)job.getMaxRetryTimes());
        }
        return SqlHelper.retBool((Integer)this.jobTaskMapper.update((Object)updateJobTask, (Wrapper)updateWrapper));
    }

    private boolean isNeedRetry(ClientCallbackContext context) {
        JobTask jobTask = (JobTask)this.jobTaskMapper.selectById((Serializable)context.getTaskId());
        Job job = (Job)this.jobMapper.selectById((Serializable)context.getJobId());
        context.setJob(job);
        context.setJobTask(jobTask);
        if (Objects.isNull(jobTask) || Objects.isNull(job)) {
            return Boolean.FALSE;
        }
        if (Objects.nonNull(context.getRetryScene()) && Objects.equals(JobRetrySceneEnum.MANUAL.getRetryScene(), context.getRetryScene()) && !context.isRetry()) {
            return Boolean.TRUE;
        }
        if (context.getTaskStatus().equals(JobTaskStatusEnum.FAIL.getStatus()) && jobTask.getRetryCount() < job.getMaxRetryTimes()) {
            context.setRetryScene(JobRetrySceneEnum.AUTO.getRetryScene());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected abstract String chooseNewClient(ClientCallbackContext var1);

    protected abstract void doCallback(ClientCallbackContext var1);

    public void afterPropertiesSet() throws Exception {
        ClientCallbackFactory.registerJobExecutor(this.getTaskInstanceType(), this);
    }
}

