/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.callback;

import akka.actor.ActorRef;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.RandomUtil;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.callback.AbstractClientCallbackHandler;
import com.aizuda.snailjob.server.job.task.support.callback.ClientCallbackContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Collection;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class MapReduceClientCallbackHandler
extends AbstractClientCallbackHandler {
    private final JobTaskMapper jobTaskMapper;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.MAP_REDUCE;
    }

    @Override
    protected void doCallback(ClientCallbackContext context) {
        JobTask jobTask = (JobTask)this.jobTaskMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(JobTask::getId, (Object)context.getTaskId()));
        Assert.notNull((Object)jobTask, () -> new SnailJobServerException("job task is null"));
        JobExecutorResultDTO jobExecutorResultDTO = JobTaskConverter.INSTANCE.toJobExecutorResultDTO(context);
        jobExecutorResultDTO.setTaskId(context.getTaskId());
        jobExecutorResultDTO.setMessage(context.getExecuteResult().getMessage());
        jobExecutorResultDTO.setResult(context.getExecuteResult().getResult());
        jobExecutorResultDTO.setTaskType(this.getTaskInstanceType().getType());
        jobExecutorResultDTO.setIsLeaf(jobTask.getLeaf());
        ActorRef actorRef = ActorGenerator.jobTaskExecutorResultActor();
        actorRef.tell((Object)jobExecutorResultDTO, actorRef);
    }

    @Override
    protected String chooseNewClient(ClientCallbackContext context) {
        Set nodes = CacheRegisterTable.getServerNodeSet((String)context.getGroupName(), (String)context.getNamespaceId());
        if (CollUtil.isEmpty((Collection)nodes)) {
            SnailJobLog.LOCAL.error("\u65e0\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef\u4fe1\u606f. jobId:[{}]", new Object[]{context.getJobId()});
            return null;
        }
        RegisterNodeInfo serverNode = (RegisterNodeInfo)RandomUtil.randomEle((Object[])nodes.toArray(new RegisterNodeInfo[0]));
        return ClientInfoUtils.generate((RegisterNodeInfo)serverNode);
    }

    public MapReduceClientCallbackHandler(JobTaskMapper jobTaskMapper) {
        this.jobTaskMapper = jobTaskMapper;
    }
}

