/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.dispatch;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.dto.CompleteJobBatchDTO;
import com.aizuda.snailjob.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.JobTaskStopHandler;
import com.aizuda.snailjob.server.job.task.support.handler.DistributedLockHandler;
import com.aizuda.snailjob.server.job.task.support.handler.JobTaskBatchHandler;
import com.aizuda.snailjob.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.snailjob.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Objects;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="JobExecutorResultActor")
@Scope(value="prototype")
public class JobExecutorResultActor
extends AbstractActor {
    private static final String KEY = "job_complete_{0}_{1}";
    private final JobTaskMapper jobTaskMapper;
    private final JobTaskBatchHandler jobTaskBatchHandler;
    private final DistributedLockHandler distributedLockHandler;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(JobExecutorResultDTO.class, result -> {
            SnailJobLog.LOCAL.debug("\u66f4\u65b0\u4efb\u52a1\u72b6\u6001. \u53c2\u6570:[{}]", new Object[]{JsonUtil.toJsonString((Object)result)});
            try {
                Assert.notNull((Object)result.getTaskId(), () -> new SnailJobServerException("taskId can not be null"));
                Assert.notNull((Object)result.getJobId(), () -> new SnailJobServerException("jobId can not be null"));
                Assert.notNull((Object)result.getTaskBatchId(), () -> new SnailJobServerException("taskBatchId can not be null"));
                Assert.notNull((Object)result.getTaskType(), () -> new SnailJobServerException("taskType can not be null"));
                JobTask jobTask = new JobTask();
                jobTask.setTaskStatus(result.getTaskStatus());
                jobTask.setWfContext(result.getWfContext());
                if (Objects.nonNull(result.getResult())) {
                    if (result.getResult() instanceof String) {
                        jobTask.setResultMessage((String)result.getResult());
                    } else {
                        jobTask.setResultMessage(JsonUtil.toJsonString((Object)result.getResult()));
                    }
                }
                Assert.isTrue((1 == this.jobTaskMapper.update((Object)jobTask, (Wrapper)new LambdaUpdateWrapper().eq(JobTask::getId, (Object)result.getTaskId())) ? 1 : 0) != 0, () -> new SnailJobServerException("\u66f4\u65b0\u4efb\u52a1\u5b9e\u4f8b\u5931\u8d25"));
                if (Objects.nonNull(result.getIsLeaf()) && StatusEnum.NO.getStatus().equals(result.getIsLeaf())) {
                    return;
                }
                boolean tryCompleteAndStop = this.tryCompleteAndStop((JobExecutorResultDTO)result);
                if (!tryCompleteAndStop) {
                    this.distributedLockHandler.lockWithDisposableAndRetry(() -> this.tryCompleteAndStop((JobExecutorResultDTO)result), MessageFormat.format(KEY, result.getTaskBatchId(), result.getJobId()), Duration.ofSeconds(1L), Duration.ofSeconds(1L), 3);
                }
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error(" job executor result exception. [{}]", new Object[]{result, e});
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private boolean tryCompleteAndStop(JobExecutorResultDTO result) {
        CompleteJobBatchDTO completeJobBatchDTO = JobTaskConverter.INSTANCE.toCompleteJobBatchDTO(result);
        boolean complete = this.jobTaskBatchHandler.complete(completeJobBatchDTO);
        if (complete && result.getTaskType().intValue() != JobTaskTypeEnum.CLUSTER.getType()) {
            JobTaskStopHandler instanceInterrupt = JobTaskStopFactory.getJobTaskStop(result.getTaskType());
            TaskStopJobContext stopJobContext = JobTaskConverter.INSTANCE.toStopJobContext(result);
            stopJobContext.setNeedUpdateTaskStatus(Boolean.FALSE);
            stopJobContext.setForceStop(Boolean.TRUE);
            instanceInterrupt.stop(stopJobContext);
        }
        return complete;
    }

    public JobExecutorResultActor(JobTaskMapper jobTaskMapper, JobTaskBatchHandler jobTaskBatchHandler, DistributedLockHandler distributedLockHandler) {
        this.jobTaskMapper = jobTaskMapper;
        this.jobTaskBatchHandler = jobTaskBatchHandler;
        this.distributedLockHandler = distributedLockHandler;
    }
}

