/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.executor.workflow;

import akka.actor.ActorRef;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.dto.JobLogMetaDTO;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.AbstractWorkflowExecutor;
import com.aizuda.snailjob.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class JobTaskWorkflowExecutor
extends AbstractWorkflowExecutor {
    @Override
    public WorkflowNodeTypeEnum getWorkflowNodeType() {
        return WorkflowNodeTypeEnum.JOB_TASK;
    }

    @Override
    protected boolean doPreValidate(WorkflowExecutorContext context) {
        return true;
    }

    @Override
    protected void afterExecute(WorkflowExecutorContext context) {
    }

    @Override
    protected void beforeExecute(WorkflowExecutorContext context) {
    }

    @Override
    protected void doExecute(WorkflowExecutorContext context) {
        if (JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(context.getParentOperationReason())) {
            context.setTaskBatchStatus(JobTaskBatchStatusEnum.CANCEL.getStatus());
            context.setOperationReason(JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason());
            context.setJobTaskStatus(JobTaskStatusEnum.CANCEL.getStatus());
            this.invokeCancelJobTask(context, "\u5f53\u524d\u8282\u70b9\u65e0\u9700\u5904\u7406");
        } else if (Objects.equals(context.getWorkflowNodeStatus(), StatusEnum.NO.getStatus())) {
            context.setTaskBatchStatus(JobTaskBatchStatusEnum.CANCEL.getStatus());
            context.setOperationReason(JobOperationReasonEnum.WORKFLOW_NODE_CLOSED_SKIP_EXECUTION.getReason());
            context.setJobTaskStatus(JobTaskStatusEnum.CANCEL.getStatus());
            this.invokeCancelJobTask(context, "\u4efb\u52a1\u5df2\u5173\u95ed");
        } else {
            JobTaskWorkflowExecutor.invokeJobTask(context);
        }
    }

    private static void invokeJobTask(WorkflowExecutorContext context) {
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(context.getJob(), context);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli() + DateUtils.toNowMilli() % 1000L);
        ActorRef actorRef = ActorGenerator.jobTaskPrepareActor();
        actorRef.tell((Object)jobTaskPrepare, actorRef);
    }

    private void invokeCancelJobTask(WorkflowExecutorContext context, String cancelReason) {
        JobTaskBatch jobTaskBatch = this.generateJobTaskBatch(context);
        JobTask jobTask = this.generateJobTask(context, jobTaskBatch);
        JobLogMetaDTO jobLogMetaDTO = new JobLogMetaDTO();
        jobLogMetaDTO.setNamespaceId(context.getNamespaceId());
        jobLogMetaDTO.setGroupName(context.getGroupName());
        jobLogMetaDTO.setTaskBatchId(jobTaskBatch.getId());
        jobLogMetaDTO.setJobId(context.getJobId());
        jobLogMetaDTO.setTaskId(jobTask.getId());
        SnailJobLog.REMOTE.warn("\u8282\u70b9[{}]\u5df2\u53d6\u6d88\u4efb\u52a1\u6267\u884c. \u53d6\u6d88\u539f\u56e0: {}. <|>{}<|>", new Object[]{context.getWorkflowNodeId(), cancelReason, jobLogMetaDTO});
    }

    @Generated
    public JobTaskWorkflowExecutor() {
    }
}

