/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.schedule;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.schedule.AbstractSchedule;
import com.aizuda.snailjob.server.common.triple.Triple;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.DashboardRetryResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetrySummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySummary;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class RetrySummarySchedule
extends AbstractSchedule
implements Lifecycle {
    private final RetryTaskLogMapper retryTaskLogMapper;
    private final RetrySummaryMapper retrySummaryMapper;
    private final SystemProperties systemProperties;

    public String lockName() {
        return "retrySummaryDashboard";
    }

    public String lockAtMost() {
        return "PT1M";
    }

    public String lockAtLeast() {
        return "PT20S";
    }

    protected void doExecute() {
        try {
            for (int i = 0; i < this.systemProperties.getSummaryDay(); ++i) {
                LocalDateTime todayFrom = LocalDateTime.of(LocalDate.now(), LocalTime.MIN).plusDays(-i);
                LocalDateTime todayTo = LocalDateTime.of(LocalDate.now(), LocalTime.MAX).plusDays(-i);
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().between(CreateDt::getCreateDt, (Object)todayFrom, (Object)todayTo)).groupBy(RetryTaskLog::getNamespaceId, new SFunction[]{RetryTaskLog::getGroupName, RetryTaskLog::getSceneName});
                List dashboardRetryResponseDOList = this.retryTaskLogMapper.selectRetryRetryTaskLogSummaryList((Wrapper)wrapper);
                if (CollUtil.isEmpty((Collection)dashboardRetryResponseDOList)) continue;
                List<RetrySummary> retrySummaryList = this.retrySummaryList(todayFrom, dashboardRetryResponseDOList);
                HashSet groupNames = Sets.newHashSet();
                HashSet namespaceIds = Sets.newHashSet();
                HashSet sceneNames = Sets.newHashSet();
                for (RetrySummary retrySummary2 : retrySummaryList) {
                    groupNames.add(retrySummary2.getGroupName());
                    namespaceIds.add(retrySummary2.getNamespaceId());
                    sceneNames.add(retrySummary2.getSceneName());
                }
                List retrySummaries = this.retrySummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetrySummary::getGroupName, (Collection)groupNames)).in(RetrySummary::getNamespaceId, (Collection)namespaceIds)).in(RetrySummary::getSceneName, (Collection)sceneNames)).eq(RetrySummary::getTriggerAt, (Object)todayFrom));
                Map summaryMap = StreamUtils.toIdentityMap((Collection)retrySummaries, retrySummary -> Triple.of((Object)this.mergeKey((RetrySummary)retrySummary), (Object)retrySummary.getSceneName(), (Object)retrySummary.getTriggerAt()));
                ArrayList waitInserts = Lists.newArrayList();
                ArrayList waitUpdates = Lists.newArrayList();
                for (RetrySummary retrySummary3 : retrySummaryList) {
                    if (Objects.isNull(summaryMap.get(Triple.of((Object)this.mergeKey(retrySummary3), (Object)retrySummary3.getSceneName(), (Object)retrySummary3.getTriggerAt())))) {
                        waitInserts.add(retrySummary3);
                        continue;
                    }
                    waitUpdates.add(retrySummary3);
                }
                int insertTotalRetrySummary = 0;
                if (CollUtil.isNotEmpty((Collection)waitInserts)) {
                    insertTotalRetrySummary = this.retrySummaryMapper.insertBatch((List)waitInserts);
                }
                int updateTotalRetrySummary = 0;
                if (CollUtil.isNotEmpty((Collection)waitUpdates)) {
                    updateTotalRetrySummary = this.retrySummaryMapper.updateBatch((List)waitUpdates);
                }
                SnailJobLog.LOCAL.debug("retry summary dashboard success todayFrom:[{}] todayTo:[{}] insertTotalRetrySummary:[{}] updateTotalRetrySummary:[{}]", new Object[]{todayFrom, todayTo, insertTotalRetrySummary, updateTotalRetrySummary});
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("retry summary dashboard log error", new Object[]{e});
        }
    }

    private String mergeKey(RetrySummary retrySummary) {
        return retrySummary.getGroupName() + retrySummary.getNamespaceId();
    }

    private List<RetrySummary> retrySummaryList(LocalDateTime triggerAt, List<DashboardRetryResponseDO> dashboardRetryResponseDOList) {
        ArrayList<RetrySummary> retrySummaryList = new ArrayList<RetrySummary>();
        for (DashboardRetryResponseDO dashboardRetryResponseDO : dashboardRetryResponseDOList) {
            RetrySummary retrySummary = new RetrySummary();
            retrySummary.setTriggerAt(triggerAt);
            retrySummary.setNamespaceId(dashboardRetryResponseDO.getNamespaceId());
            retrySummary.setGroupName(dashboardRetryResponseDO.getGroupName());
            retrySummary.setSceneName(dashboardRetryResponseDO.getSceneName());
            retrySummary.setRunningNum(dashboardRetryResponseDO.getRunningNum());
            retrySummary.setFinishNum(dashboardRetryResponseDO.getFinishNum());
            retrySummary.setMaxCountNum(dashboardRetryResponseDO.getMaxCountNum());
            retrySummary.setSuspendNum(dashboardRetryResponseDO.getSuspendNum());
            retrySummaryList.add(retrySummary);
        }
        return retrySummaryList;
    }

    public void start() {
        this.taskScheduler.scheduleAtFixedRate(() -> ((RetrySummarySchedule)this).execute(), Duration.parse("PT1M"));
    }

    public void close() {
    }

    public RetrySummarySchedule(RetryTaskLogMapper retryTaskLogMapper, RetrySummaryMapper retrySummaryMapper, SystemProperties systemProperties) {
        this.retryTaskLogMapper = retryTaskLogMapper;
        this.retrySummaryMapper = retrySummaryMapper;
        this.systemProperties = systemProperties;
    }
}

