/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.dto.RetryAlarmInfo;
import com.aizuda.snailjob.server.common.dto.RetryLogMetaDTO;
import com.aizuda.snailjob.server.model.dto.RetryLogTaskDTO;
import com.aizuda.snailjob.server.model.dto.RetryTaskDTO;
import com.aizuda.snailjob.server.retry.task.dto.NotifyConfigDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryPartitionTask;
import com.aizuda.snailjob.server.retry.task.dto.RetrySceneConfigPartitionTask;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskExecutorDTO;
import com.aizuda.snailjob.server.retry.task.dto.RetryTaskFailAlarmEventDTO;
import com.aizuda.snailjob.server.retry.task.generator.task.TaskContext;
import com.aizuda.snailjob.server.retry.task.support.timer.RetryTimerContext;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTaskLogMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface RetryTaskConverter {
    public static final RetryTaskConverter INSTANCE = (RetryTaskConverter)Mappers.getMapper(RetryTaskConverter.class);

    public RetryTask toRetryTask(RetryTaskExecutorDTO var1);

    public RetryTask toRetryTask(RetryTaskDTO var1);

    public RetryTask toRetryTask(RetryTask var1);

    @Mappings(value={@Mapping(target="id", ignore=true)})
    public RetryTask toRetryTask(RetryDeadLetter var1);

    public List<RetryTask> toRetryTaskList(List<RetryTaskDTO> var1);

    public RetryTask toRetryTask(TaskContext.TaskInfo var1);

    public List<RetryPartitionTask> toRetryPartitionTasks(List<RetryTask> var1);

    public List<RetryPartitionTask> toRetryTaskLogPartitionTasks(List<RetryTaskLog> var1);

    public RetryTimerContext toRetryTimerContext(RetryPartitionTask var1);

    public List<NotifyConfigDTO> toNotifyConfigDTO(List<NotifyConfig> var1);

    public List<RetrySceneConfigPartitionTask> toRetrySceneConfigPartitionTask(List<RetrySceneConfig> var1);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(RetryTaskConverter.toNotifyIds(retrySceneConfig.getNotifyIds()))")})
    public RetrySceneConfigPartitionTask toRetrySceneConfigPartitionTask(RetrySceneConfig var1);

    @Mappings(value={@Mapping(target="recipientIds", expression="java(RetryTaskConverter.toNotifyRecipientIds(notifyConfig.getRecipientIds()))")})
    public NotifyConfigDTO toNotifyConfigDTO(NotifyConfig var1);

    public static Set<Long> toNotifyIds(String notifyIdsStr) {
        if (StrUtil.isBlank((CharSequence)notifyIdsStr)) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JsonUtil.parseList((String)notifyIdsStr, Long.class));
    }

    public static Set<Long> toNotifyRecipientIds(String notifyRecipientIdsStr) {
        if (StrUtil.isBlank((CharSequence)notifyRecipientIdsStr)) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JsonUtil.parseList((String)notifyRecipientIdsStr, Long.class));
    }

    public RetryTaskLogMessage toRetryTaskLogMessage(RetryLogTaskDTO var1);

    public RetryLogMetaDTO toLogMetaDTO(RetryTask var1);

    @Mappings(value={@Mapping(source="reason", target="reason"), @Mapping(source="notifyScene", target="notifyScene")})
    public RetryTaskExecutorDTO toRetryTaskExecutorDTO(RetryTask var1, String var2, Integer var3);

    @Mappings(value={@Mapping(source="reason", target="reason"), @Mapping(source="notifyScene", target="notifyScene")})
    public RetryTaskFailAlarmEventDTO toRetryTaskFailAlarmEventDTO(RetryTask var1, String var2, Integer var3);

    public List<RetryAlarmInfo> toRetryTaskFailAlarmEventDTO(List<RetryTaskFailAlarmEventDTO> var1);
}

