/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.retry.task.support.dispatch.task;

import akka.actor.ActorRef;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.akka.ActorGenerator;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.retry.task.support.RetryContext;
import com.aizuda.snailjob.server.retry.task.support.context.CallbackRetryContext;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.AbstractTaskExecutor;
import com.aizuda.snailjob.server.retry.task.support.dispatch.task.TaskExecutorSceneEnum;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryBuilder;
import com.aizuda.snailjob.server.retry.task.support.retry.RetryExecutor;
import com.aizuda.snailjob.server.retry.task.support.strategy.FilterStrategies;
import com.aizuda.snailjob.server.retry.task.support.strategy.StopStrategies;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import org.springframework.stereotype.Component;

@Component
public class ManualCallbackTaskExecutor
extends AbstractTaskExecutor {
    @Override
    protected RetryContext builderRetryContext(String groupName, RetryTask retryTask, RetrySceneConfig retrySceneConfig) {
        CallbackRetryContext retryContext = new CallbackRetryContext();
        retryContext.setRetryTask(retryTask);
        retryContext.setSceneBlacklist(this.accessTemplate.getSceneConfigAccess().getBlacklist(groupName, retrySceneConfig.getNamespaceId()));
        retryContext.setServerNode(this.clientNodeAllocateHandler.getServerNode(retryTask.getSceneName(), retryTask.getGroupName(), retryTask.getNamespaceId(), retrySceneConfig.getRouteKey()));
        retryContext.setRetrySceneConfig(retrySceneConfig);
        return retryContext;
    }

    @Override
    protected RetryExecutor builderResultRetryExecutor(RetryContext retryContext, RetrySceneConfig retrySceneConfig) {
        return RetryBuilder.newBuilder().withStopStrategy(StopStrategies.stopException()).withStopStrategy(StopStrategies.stopResultStatus()).withWaitStrategy(this.getWaitWaitStrategy()).withFilterStrategy(FilterStrategies.bitSetIdempotentFilter(this.idempotentStrategy)).withFilterStrategy(FilterStrategies.sceneBlackFilter()).withFilterStrategy(FilterStrategies.checkAliveClientPodFilter()).withFilterStrategy(FilterStrategies.rebalanceFilterStrategies()).withFilterStrategy(FilterStrategies.rateLimiterFilter()).withRetryContext(retryContext).build();
    }

    @Override
    protected boolean preCheck(RetryContext retryContext, RetryExecutor executor) {
        Pair<Boolean, StringBuilder> pair = executor.filter();
        Assert.isTrue((boolean)((Boolean)pair.getKey()), () -> new SnailJobServerException(((StringBuilder)pair.getValue()).toString()));
        return (Boolean)pair.getKey();
    }

    @Override
    public TaskExecutorSceneEnum getTaskType() {
        return TaskExecutorSceneEnum.MANUAL_CALLBACK;
    }

    private WaitStrategy getWaitWaitStrategy() {
        return WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)WaitStrategies.WaitStrategyEnum.FIXED.getType());
    }

    @Override
    protected ActorRef getActorRef() {
        return ActorGenerator.execCallbackUnitActor();
    }
}

