/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.config;

import com.ql.util.express.exception.QLTimeOutException;

public class QLExpressTimer {
    private static ThreadLocal<Boolean> NEED_TIMER = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static ThreadLocal<Long> TIME_OUT_MILLIS = new ThreadLocal<Long>(){};
    private static ThreadLocal<Long> START_TIME = new ThreadLocal<Long>(){};
    private static ThreadLocal<Long> END_TIME = new ThreadLocal<Long>(){};

    public static void setTimer(long timeoutMillis) {
        NEED_TIMER.set(true);
        TIME_OUT_MILLIS.set(timeoutMillis);
    }

    public static void startTimer() {
        if (NEED_TIMER.get().booleanValue()) {
            long t = System.currentTimeMillis();
            START_TIME.set(t);
            END_TIME.set(t + TIME_OUT_MILLIS.get());
        }
    }

    public static void assertTimeOut() throws QLTimeOutException {
        if (NEED_TIMER.get().booleanValue() && System.currentTimeMillis() > END_TIME.get()) {
            throw new QLTimeOutException("\u8fd0\u884cQLExpress\u811a\u672c\u7684\u4e0b\u4e00\u6761\u6307\u4ee4\u5c06\u8d85\u8fc7\u4e86\u9650\u5b9a\u65f6\u95f4:" + TIME_OUT_MILLIS.get() + "ms");
        }
    }

    public static boolean hasExpired() {
        return NEED_TIMER.get() != false && System.currentTimeMillis() > END_TIME.get();
    }

    public static void reset() {
        if (NEED_TIMER.get().booleanValue()) {
            START_TIME.remove();
            END_TIME.remove();
            NEED_TIMER.remove();
            TIME_OUT_MILLIS.remove();
        }
    }
}

