/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.op;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.ExpressUtil;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.config.QLExpressRunStrategy;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.op.OperatorBase;
import com.ql.util.express.instruction.opdata.OperateClass;
import com.ql.util.express.instruction.opdata.OperateDataVirClass;
import com.ql.util.express.parse.AppendingClassMethodManager;
import java.lang.reflect.Method;

public class OperatorMethod
extends OperatorBase {
    String methodName;
    static Class<?> ArrayClass = new Object[0].getClass();

    public OperatorMethod() {
        this.name = "MethodCall";
    }

    public OperatorMethod(String aMethodName) {
        this.name = "MethodCall";
        this.methodName = aMethodName;
    }

    @Override
    public OperateData executeInner(InstructionSetContext parent, ArraySwap list) throws Exception {
        AppendingClassMethodManager.AppendingMethod appendingClassMethod;
        Object tmpObj;
        OperateData p0 = list.get(0);
        Object obj = p0.getObject(parent);
        if (obj instanceof OperateDataVirClass) {
            OperateDataVirClass vClass = (OperateDataVirClass)obj;
            OperateData[] parameters = new OperateData[list.length - 1];
            for (int i = 0; i < list.length - 1; ++i) {
                parameters[i] = list.get(i + 1);
            }
            return vClass.callSelfFunction(this.methodName, parameters);
        }
        if (obj == null) {
            if (QLExpressRunStrategy.isAvoidNullPointer()) {
                return null;
            }
            String msg = "\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c\u65b9\u6cd5:";
            throw new QLException(msg + this.methodName);
        }
        Class[] types = new Class[list.length - 1];
        Class[] orgiTypes = new Class[list.length - 1];
        Object[] objs = new Object[list.length - 1];
        for (int i = 0; i < types.length; ++i) {
            OperateData p = list.get(i + 1);
            tmpObj = p.getObject(parent);
            types[i] = p.getType(parent);
            orgiTypes[i] = p.getType(parent);
            objs[i] = tmpObj;
        }
        AppendingClassMethodManager appendingClassMethodManager = parent.getExpressRunner().getAppendingClassMethodManager();
        if (appendingClassMethodManager != null && (appendingClassMethod = appendingClassMethodManager.getAppendingClassMethod(obj, this.methodName)) != null) {
            return appendingClassMethodManager.invoke(appendingClassMethod, parent, list, null);
        }
        Method m = null;
        if (p0 instanceof OperateClass) {
            m = ExpressUtil.findMethodWithCache((Class)obj, this.methodName, types, true, true);
        } else {
            if (obj instanceof Class) {
                m = ExpressUtil.findMethodWithCache((Class)obj, this.methodName, types, true, true);
            }
            if (m == null) {
                m = ExpressUtil.findMethodWithCache(obj.getClass(), this.methodName, types, true, false);
            }
        }
        if (m == null) {
            types = new Class[]{ArrayClass};
            m = p0 instanceof OperateClass ? ExpressUtil.findMethodWithCache((Class)obj, this.methodName, types, true, true) : ExpressUtil.findMethodWithCache(obj.getClass(), this.methodName, types, true, false);
            objs = new Object[]{objs};
        }
        if (m == null) {
            StringBuilder s = new StringBuilder();
            s.append("\u6ca1\u6709\u627e\u5230" + obj.getClass().getName() + "\u7684\u65b9\u6cd5\uff1a" + this.methodName + "(");
            for (int i = 0; i < orgiTypes.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                if (orgiTypes[i] == null) {
                    s.append("null");
                    continue;
                }
                s.append(orgiTypes[i].getName());
            }
            s.append(")");
            throw new QLException(s.toString());
        }
        QLExpressRunStrategy.assertBlackMethod(m);
        if (p0 instanceof OperateClass) {
            boolean oldA = m.isAccessible();
            m.setAccessible(true);
            tmpObj = m.invoke(null, ExpressUtil.transferArray(objs, m.getParameterTypes()));
            m.setAccessible(oldA);
        } else {
            boolean oldA = m.isAccessible();
            m.setAccessible(true);
            tmpObj = m.invoke(obj, ExpressUtil.transferArray(objs, m.getParameterTypes()));
            m.setAccessible(oldA);
        }
        return OperateDataCacheManager.fetchOperateData(tmpObj, m.getReturnType());
    }

    @Override
    public String toString() {
        return this.name + ":" + this.methodName;
    }
}

