/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.rule;

import com.ql.util.express.ExpressRunner;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.parse.ExpressNode;
import com.ql.util.express.parse.Word;
import com.ql.util.express.rule.Action;
import com.ql.util.express.rule.Condition;
import com.ql.util.express.rule.ConditionType;
import com.ql.util.express.rule.Rule;
import com.ql.util.express.rule.RuleCase;
import com.ql.util.express.rule.RuleResult;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleManager {
    private static final Log log = LogFactory.getLog(RuleManager.class);

    public static RuleResult executeRule(ExpressRunner runner, Rule rule, IExpressContext<String, Object> context, boolean isCache, boolean isTrace) {
        RuleResult result = new RuleResult();
        result.setRule(rule);
        LinkedHashMap<String, Boolean> traceMap = new LinkedHashMap<String, Boolean>();
        result.setTraceMap(traceMap);
        Object actionResult = null;
        for (RuleCase ruleCase : rule.getRuleCases()) {
            Condition root = ruleCase.getCondition();
            Boolean conditionResult = RuleManager.calculateCondition(runner, context, root, traceMap, isCache, isTrace, result);
            if (!conditionResult.booleanValue()) continue;
            for (Action action : ruleCase.getActions()) {
                try {
                    traceMap.put(action.getNodeId() + "", true);
                    actionResult = runner.execute(action.getText(), context, null, isCache, isTrace);
                }
                catch (Exception e) {
                    result.setHasException(true);
                    log.error((Object)("\u6267\u884caction\u51fa\u9519:action=\n" + action.getText()), (Throwable)e);
                    actionResult = null;
                }
            }
        }
        result.setResult(actionResult);
        return result;
    }

    private static Boolean calculateCondition(ExpressRunner runner, IExpressContext<String, Object> context, Condition root, Map<String, Boolean> traceMap, boolean isCache, boolean isTrace, RuleResult result) {
        boolean isShortCircuit = runner.isShortCircuit();
        String key = root.getNodeId() + "";
        if (root.getType() == ConditionType.Leaf) {
            String text = root.getText();
            try {
                Boolean r = (Boolean)runner.execute(text, context, null, isCache, isTrace);
                traceMap.put(key, r);
                return r;
            }
            catch (Exception e) {
                result.setHasException(true);
                log.error((Object)("\u8ba1\u7b97condition\u51fa\u9519:condition=\n" + text), (Throwable)e);
                traceMap.put(key, false);
                return false;
            }
        }
        Boolean unionLogicResult = null;
        ConditionType rootType = root.getType();
        if (root.getChildren() != null) {
            for (Condition sub : root.getChildren()) {
                Boolean subResult = RuleManager.calculateCondition(runner, context, sub, traceMap, isCache, isTrace, result);
                if (unionLogicResult == null) {
                    unionLogicResult = subResult;
                } else if (rootType == ConditionType.And) {
                    unionLogicResult = unionLogicResult != false && subResult != false;
                } else if (rootType == ConditionType.Or) {
                    unionLogicResult = unionLogicResult != false || subResult != false;
                }
                if (!isShortCircuit || (rootType != ConditionType.And || unionLogicResult.booleanValue()) && (rootType != ConditionType.Or || !unionLogicResult.booleanValue())) continue;
                break;
            }
        }
        traceMap.put(key, unionLogicResult);
        return unionLogicResult;
    }

    public static Rule createRule(ExpressNode root, Word[] words) {
        ExpressNode ifNode = RuleManager.getIfRootNode(root);
        if (ifNode != null) {
            Rule rule = new Rule();
            RuleManager.addRuleCaseByExpress(ifNode, rule, words);
            RuleManager.tagRuleConitionId(rule);
            return rule;
        }
        return null;
    }

    private static Integer tagRuleConitionId(Rule rule) {
        Integer nodeId = 0;
        Integer level = 0;
        Object object = nodeId;
        Integer n = nodeId = Integer.valueOf(nodeId + 1);
        rule.setNodeId((Integer)object);
        object = level;
        n = level = Integer.valueOf(level + 1);
        rule.setLevel((Integer)object);
        for (RuleCase ruleCase : rule.getRuleCases()) {
            Integer n2 = nodeId;
            Integer n3 = nodeId = Integer.valueOf(nodeId + 1);
            ruleCase.setNodeId(n2);
            ruleCase.setLevel(level);
            Condition root = ruleCase.getCondition();
            nodeId = RuleManager.tagConditionNode(root, nodeId, level + 1);
            List<Action> actions = ruleCase.getActions();
            for (Action action : actions) {
                action.setLevel(level + 1);
                Integer n4 = nodeId;
                Integer n5 = nodeId = Integer.valueOf(nodeId + 1);
                action.setNodeId(n4);
            }
        }
        return nodeId;
    }

    private static Integer tagConditionNode(Condition root, Integer nodeId, Integer level) {
        root.setLevel(level);
        Integer n = nodeId;
        Integer n2 = nodeId = Integer.valueOf(nodeId + 1);
        root.setNodeId(n);
        if (root.getChildren() != null) {
            for (Condition sub : root.getChildren()) {
                nodeId = RuleManager.tagConditionNode(sub, nodeId, level + 1);
            }
        }
        return nodeId;
    }

    private static void addRuleCaseByExpress(ExpressNode ifNode, Rule rule, Word[] words) {
        ExpressNode[] children = ifNode.getChildren();
        ExpressNode condtion = null;
        ExpressNode action = null;
        ExpressNode nextCase = null;
        int point = 0;
        ExpressNode first = children[point];
        condtion = RuleManager.isNodeType(first, "CHILD_EXPRESS") ? first.getChildren()[0] : first;
        if (RuleManager.isNodeType(children[++point], "then")) {
            ++point;
        }
        action = children[point];
        if (++point < children.length && RuleManager.isNodeType(children[point], "else") && ++point < children.length && RuleManager.isNodeType(children[point], "if")) {
            nextCase = children[point];
        }
        rule.addRuleCases(RuleManager.createRuleCase(condtion, action, words));
        if (nextCase != null) {
            RuleManager.addRuleCaseByExpress(nextCase, rule, words);
        }
    }

    private static ExpressNode getIfRootNode(ExpressNode parent) {
        if (RuleManager.isNodeType(parent, "if")) {
            return parent;
        }
        ExpressNode[] children = parent.getChildren();
        if (children != null && children.length > 0) {
            for (ExpressNode child : children) {
                if (RuleManager.getIfRootNode(child) == null) continue;
                return child;
            }
        }
        return null;
    }

    private static RuleCase createRuleCase(ExpressNode condition, ExpressNode action, Word[] words) {
        Condition ruleCondition = new Condition();
        RuleManager.transferCondition(condition, ruleCondition, words);
        ArrayList<Action> actions = new ArrayList<Action>();
        if (RuleManager.isNodeType(action, "STAT_BLOCK")) {
            ExpressNode[] children;
            for (ExpressNode actionChild : children = action.getChildren()) {
                actions.add(new Action(RuleManager.makeActionString(actionChild, words)));
            }
        } else {
            actions.add(new Action(RuleManager.makeActionString(action, words)));
        }
        RuleCase ruleCase = new RuleCase(ruleCondition, actions);
        return ruleCase;
    }

    private static void transferCondition(ExpressNode express, Condition condition, Word[] words) {
        if (RuleManager.isNodeType(express, "&&")) {
            ExpressNode[] children;
            condition.setType(ConditionType.And);
            condition.setText("and");
            for (ExpressNode child : children = express.getChildren()) {
                Condition subCondition = new Condition();
                condition.addChild(subCondition);
                RuleManager.transferCondition(child, subCondition, words);
            }
        } else if (RuleManager.isNodeType(express, "||")) {
            ExpressNode[] children;
            condition.setType(ConditionType.Or);
            condition.setText("or");
            for (ExpressNode child : children = express.getChildren()) {
                Condition subCondition = new Condition();
                condition.addChild(subCondition);
                RuleManager.transferCondition(child, subCondition, words);
            }
        } else if (RuleManager.isNodeType(express, "CHILD_EXPRESS") || RuleManager.isNodeType(express, "STAT_BLOCK") || RuleManager.isNodeType(express, "STAT_SEMICOLON")) {
            ExpressNode realExpress = express.getChildren()[0];
            condition.setPrior(true);
            RuleManager.transferCondition(realExpress, condition, words);
        } else {
            condition.setType(ConditionType.Leaf);
            condition.setText(RuleManager.makeCondtionString(express, words));
        }
    }

    private static boolean isNodeType(ExpressNode node, String type) {
        return node.getNodeType().getName().equals(type);
    }

    private static String makeActionString(ExpressNode express, Word[] words) {
        int min = RuleManager.getMinNode(express);
        int max = RuleManager.getMaxNode(express);
        while (max + 1 < words.length && (words[max + 1].word.equals(")") || words[max + 1].word.equals("("))) {
            ++max;
        }
        if (min < 0) {
            min = 0;
        }
        if (max >= words.length) {
            max = words.length - 1;
        }
        StringBuilder result = new StringBuilder();
        int balance = 0;
        for (int i = min; i <= max; ++i) {
            if (words[i].word.equals("(")) {
                ++balance;
            } else if (words[i].word.equals(")")) {
                --balance;
            }
            if (balance < 0) {
                ++balance;
                break;
            }
            result.append(words[i].word);
            if (!words[i].word.equals("return")) continue;
            result.append(" ");
        }
        if (balance != 0) {
            System.out.println(result);
            throw new RuntimeException("\u62ec\u53f7\u5339\u914d\u5f02\u5e38");
        }
        return result.toString();
    }

    private static String makeCondtionString(ExpressNode express, Word[] words) {
        int min = RuleManager.getMinNode(express);
        int max = RuleManager.getMaxNode(express);
        while (max + 1 < words.length && (words[max + 1].word.equals(")") || words[max + 1].word.equals("("))) {
            ++max;
        }
        if (min < 0) {
            min = 0;
        }
        if (max >= words.length) {
            max = words.length - 1;
        }
        StringBuilder result = new StringBuilder();
        int balance = 0;
        for (int i = min; i <= max; ++i) {
            if (words[i].word.equals("(")) {
                ++balance;
            } else if (words[i].word.equals(")")) {
                --balance;
            }
            if (balance < 0) {
                ++balance;
                break;
            }
            result.append(words[i].word);
        }
        if (balance != 0) {
            throw new RuntimeException("\u62ec\u53f7\u5339\u914d\u5f02\u5e38");
        }
        return result.toString();
    }

    private static int getMinNode(ExpressNode express) {
        if (express.getChildren() == null || express.getChildren().length == 0) {
            return express.getWordIndex();
        }
        int wordIndex = express.getWordIndex();
        if (express.getChildren() != null) {
            for (ExpressNode child : express.getChildren()) {
                int childIndex = RuleManager.getMinNode(child);
                if (wordIndex != -1 && childIndex >= wordIndex) continue;
                wordIndex = childIndex;
            }
        }
        return wordIndex;
    }

    private static int getMaxNode(ExpressNode express) {
        if (express.getChildren() == null || express.getChildren().length == 0) {
            return express.getWordIndex();
        }
        int wordIndex = express.getWordIndex();
        if (express.getChildren() != null) {
            for (ExpressNode child : express.getChildren()) {
                int childIndex = RuleManager.getMaxNode(child);
                if (childIndex <= wordIndex) continue;
                wordIndex = childIndex;
            }
        }
        return wordIndex;
    }

    public static Condition createCondition(ExpressNode condition, Word[] words) {
        Condition ruleCondition = new Condition();
        RuleManager.transferCondition(condition, ruleCondition, words);
        return ruleCondition;
    }
}

