/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.CallResult;
import com.ql.util.express.ExportItem;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.RunEnvironment;
import com.ql.util.express.config.QLExpressTimer;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.instruction.FunctionInstructionSet;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.detail.Instruction;
import com.ql.util.express.instruction.detail.InstructionCallSelfDefineFunction;
import com.ql.util.express.instruction.detail.InstructionConstData;
import com.ql.util.express.instruction.detail.InstructionLoadAttr;
import com.ql.util.express.instruction.detail.InstructionNewVirClass;
import com.ql.util.express.instruction.detail.InstructionOperator;
import com.ql.util.express.instruction.opdata.OperateDataLocalVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class InstructionSet {
    public static final String TYPE_CLASS = "VClass";
    public static final String TYPE_FUNCTION = "function";
    public static final String TYPE_MACRO = "macro";
    private final String type;
    private String name;
    private String globeName;
    private Instruction[] instructionList = new Instruction[0];
    private final Map<String, FunctionInstructionSet> functionDefine = new HashMap<String, FunctionInstructionSet>();
    private Map<String, Object> cacheFunctionSet = null;
    private final List<ExportItem> exportVar = new ArrayList<ExportItem>();
    private final List<OperateDataLocalVar> parameterList = new ArrayList<OperateDataLocalVar>();

    public InstructionSet(String type) {
        this.type = type;
    }

    public String[] getOutFunctionNames() {
        TreeMap result = new TreeMap();
        for (Instruction instruction : this.instructionList) {
            String functionName;
            if (!(instruction instanceof InstructionCallSelfDefineFunction) || this.functionDefine.containsKey(functionName = ((InstructionCallSelfDefineFunction)instruction).getFunctionName())) continue;
            result.put(functionName, null);
        }
        return result.keySet().toArray(new String[0]);
    }

    public String[] getVirClasses() {
        TreeMap result = new TreeMap();
        for (Instruction instruction : this.instructionList) {
            if (!(instruction instanceof InstructionNewVirClass)) continue;
            String functionName = ((InstructionNewVirClass)instruction).getClassName();
            result.put(functionName, null);
        }
        return result.keySet().toArray(new String[0]);
    }

    public String[] getOutAttrNames() throws Exception {
        TreeMap result = new TreeMap();
        for (Instruction instruction : this.instructionList) {
            if (!(instruction instanceof InstructionLoadAttr) || "null".equals(((InstructionLoadAttr)instruction).getAttrName())) continue;
            result.put(((InstructionLoadAttr)instruction).getAttrName(), null);
        }
        for (int i = 0; i < this.instructionList.length; ++i) {
            String varLocalName;
            String opName;
            Instruction instruction = this.instructionList[i];
            if (!(instruction instanceof InstructionOperator) || (opName = ((InstructionOperator)instruction).getOperator().getName()) == null) continue;
            if ("def".equalsIgnoreCase(opName) || "exportDef".equalsIgnoreCase(opName)) {
                varLocalName = (String)((InstructionConstData)this.instructionList[i - 1]).getOperateData().getObject(null);
                result.remove(varLocalName);
                continue;
            }
            if (!"alias".equalsIgnoreCase(opName) && !"exportAlias".equalsIgnoreCase(opName)) continue;
            varLocalName = (String)((InstructionConstData)this.instructionList[i - 2]).getOperateData().getObject(null);
            result.remove(varLocalName);
        }
        return result.keySet().toArray(new String[0]);
    }

    private void addArrayItem(Instruction item) {
        Instruction[] newArray = new Instruction[this.instructionList.length + 1];
        System.arraycopy(this.instructionList, 0, newArray, 0, this.instructionList.length);
        newArray[this.instructionList.length] = item;
        this.instructionList = newArray;
    }

    private void insertArrayItem(int point, Instruction item) {
        Instruction[] newArray = new Instruction[this.instructionList.length + 1];
        System.arraycopy(this.instructionList, 0, newArray, 0, point);
        System.arraycopy(this.instructionList, point, newArray, point + 1, this.instructionList.length - point);
        newArray[point] = item;
        this.instructionList = newArray;
    }

    public CallResult execute(RunEnvironment environment, InstructionSetContext context, List<String> errorList, boolean isReturnLastData) throws Exception {
        if (this.cacheFunctionSet == null) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>();
            for (FunctionInstructionSet s : this.functionDefine.values()) {
                tempMap.put(s.name, s.instructionSet);
            }
            this.cacheFunctionSet = tempMap;
        }
        context.addSymbol(this.cacheFunctionSet);
        this.executeInnerOriginalInstruction(environment, errorList);
        if (!environment.isExit() && environment.getDataStackSize() > 0) {
            OperateData tmpObject = environment.pop();
            if (tmpObject == null) {
                environment.quitExpress(null);
            } else if (isReturnLastData) {
                if (tmpObject.getType(context) != null && tmpObject.getType(context).equals(Void.TYPE)) {
                    environment.quitExpress(null);
                } else {
                    environment.quitExpress(tmpObject.getObject(context));
                }
            } else {
                environment.quitExpress(tmpObject);
            }
        }
        if (environment.getDataStackSize() > 1) {
            throw new QLException("\u5728\u8868\u8fbe\u5f0f\u6267\u884c\u5b8c\u6bd5\u540e\uff0c\u5806\u6808\u4e2d\u8fd8\u5b58\u5728\u591a\u4e2a\u6570\u636e");
        }
        return OperateDataCacheManager.fetchCallResult(environment.getReturnValue(), environment.isExit());
    }

    public void executeInnerOriginalInstruction(RunEnvironment environment, List<String> errorList) throws Exception {
        Instruction instruction = null;
        while (environment.programPoint < this.instructionList.length) {
            QLExpressTimer.assertTimeOut();
            instruction = this.instructionList[environment.programPoint];
            instruction.execute(environment, errorList);
        }
    }

    public int getInstructionLength() {
        return this.instructionList.length;
    }

    public void addMacroDefine(String macroName, FunctionInstructionSet functionInstructionSet) {
        this.functionDefine.put(macroName, functionInstructionSet);
    }

    public FunctionInstructionSet getMacroDefine(String macroName) {
        return this.functionDefine.get(macroName);
    }

    public FunctionInstructionSet[] getFunctionInstructionSets() {
        return this.functionDefine.values().toArray(new FunctionInstructionSet[0]);
    }

    public void addExportDef(ExportItem e) {
        this.exportVar.add(e);
    }

    public List<ExportItem> getExportDef() {
        return new ArrayList<ExportItem>(this.exportVar);
    }

    public OperateDataLocalVar[] getParameters() {
        return this.parameterList.toArray(new OperateDataLocalVar[0]);
    }

    public void addParameter(OperateDataLocalVar localVar) {
        this.parameterList.add(localVar);
    }

    public void addInstruction(Instruction instruction) {
        this.addArrayItem(instruction);
    }

    public void insertInstruction(int point, Instruction instruction) {
        this.insertArrayItem(point, instruction);
    }

    public Instruction getInstruction(int point) {
        return this.instructionList[point];
    }

    public int getCurrentPoint() {
        return this.instructionList.length - 1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGlobeName() {
        return this.globeName;
    }

    public void setGlobeName(String globeName) {
        this.globeName = globeName;
    }

    public boolean hasMain() {
        return this.instructionList.length > 0;
    }

    public String getType() {
        return this.type;
    }

    public void appendSpace(StringBuilder stringBuilder, int level) {
        for (int i = 0; i < level; ++i) {
            stringBuilder.append("    ");
        }
    }

    public String toString() {
        return "\n" + this.toString(0);
    }

    public String toString(int level) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (FunctionInstructionSet set : this.functionDefine.values()) {
                this.appendSpace(stringBuilder, level);
                stringBuilder.append(set.type).append(":").append(set.name).append("(");
                for (int i = 0; i < set.instructionSet.parameterList.size(); ++i) {
                    OperateDataLocalVar operateDataLocalVar = set.instructionSet.parameterList.get(i);
                    if (i > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(operateDataLocalVar.getType(null).getName()).append(" ").append(operateDataLocalVar.getName());
                }
                stringBuilder.append("){\n");
                stringBuilder.append(set.instructionSet.toString(level + 1));
                this.appendSpace(stringBuilder, level);
                stringBuilder.append("}\n");
            }
            for (int i = 0; i < this.instructionList.length; ++i) {
                this.appendSpace(stringBuilder, level);
                stringBuilder.append(i + 1).append(":").append(this.instructionList[i]).append("\n");
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

