/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.Operator;
import java.util.ArrayList;
import java.util.List;

public class AppendingClassFieldManager {
    private final List<AppendingField> appendingFields = new ArrayList<AppendingField>();

    public void addAppendingField(String name, Class<?> bindingClass, Class<?> returnType, Operator operator) {
        this.appendingFields.add(new AppendingField(name, bindingClass, returnType, operator));
    }

    public AppendingField getAppendingClassField(Object object, String fieldName) {
        for (AppendingField appendingField : this.appendingFields) {
            if (!fieldName.equals(appendingField.name) || object.getClass() != appendingField.bindingClass && !appendingField.bindingClass.isAssignableFrom(object.getClass())) continue;
            return appendingField;
        }
        return null;
    }

    public Object invoke(AppendingField appendingField, Object fieldObject) throws Exception {
        Operator operator = appendingField.operator;
        return operator.executeInner(new Object[]{fieldObject});
    }

    public static class AppendingField {
        private final String name;
        private final Class<?> bindingClass;
        private final Operator operator;
        private final Class<?> returnType;

        public AppendingField(String name, Class<?> bindingClass, Class<?> returnType, Operator operator) {
            this.name = name;
            this.bindingClass = bindingClass;
            this.operator = operator;
            this.returnType = returnType;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }
    }
}

