/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.exception.QLException;
import java.lang.reflect.Array;

public class DynamicParamsUtil {
    public static boolean supportDynamicParams = false;

    private DynamicParamsUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Object[] transferDynamicParams(InstructionSetContext context, ArraySwap list, Class<?>[] declaredParamsClasses, boolean maybeDynamicParams) throws Exception {
        Object[] params;
        if (!(maybeDynamicParams && supportDynamicParams && DynamicParamsUtil.maybeDynamicParams(context, list, declaredParamsClasses))) {
            if (declaredParamsClasses.length != list.length) {
                throw new QLException("\u5b9a\u4e49\u7684\u53c2\u6570\u957f\u5ea6\u4e0e\u8fd0\u884c\u671f\u4f20\u5165\u7684\u53c2\u6570\u957f\u5ea6\u4e0d\u4e00\u81f4");
            }
            Object[] params2 = new Object[list.length];
            for (int i = 0; i < list.length; ++i) {
                params2[i] = list.get(i).getObject(context);
            }
            return params2;
        }
        int paramLength = declaredParamsClasses.length;
        int beforeCount = paramLength - 1;
        int paramsCount = list.length - beforeCount;
        if (beforeCount >= 0 && declaredParamsClasses[beforeCount].isArray() && paramsCount >= 0) {
            Object[] lastParameters;
            Class<?> componentType = declaredParamsClasses[beforeCount].getComponentType();
            params = new Object[beforeCount + 1];
            params[beforeCount] = lastParameters = (Object[])Array.newInstance(componentType, paramsCount);
            for (int i = 0; i < list.length; ++i) {
                if (i < beforeCount) {
                    params[i] = list.get(i).getObject(context);
                    continue;
                }
                lastParameters[i - beforeCount] = list.get(i).getObject(context);
            }
        } else {
            throw new QLException("\u5b9a\u4e49\u7684\u53c2\u6570\u957f\u5ea6\u4e0e\u8fd0\u884c\u671f\u4f20\u5165\u7684\u53c2\u6570\u957f\u5ea6\u4e0d\u4e00\u81f4");
        }
        return params;
    }

    public static boolean maybeDynamicParams(Class<?>[] declaredParamsClasses) {
        int length = declaredParamsClasses.length;
        return length > 0 && declaredParamsClasses[length - 1].isArray();
    }

    private static boolean maybeDynamicParams(InstructionSetContext context, ArraySwap list, Class<?>[] declaredParamsClasses) throws Exception {
        if (declaredParamsClasses.length != list.length) {
            return true;
        }
        int length = list.length;
        Object lastParam = list.get(length - 1).getObject(context);
        return lastParam != null && !lastParam.getClass().isArray();
    }
}

