/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.NormalNumberOperator;
import com.ql.util.express.PreciseNumberOperator;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class OperatorOfNumber {
    public static final BigDecimal BIG_DECIMAL_LONG_MAX = new BigDecimal(Long.MAX_VALUE);
    public static final BigDecimal BIG_DECIMAL_LONG_MIN = new BigDecimal(Long.MIN_VALUE);
    public static final BigDecimal BIG_DECIMAL_INTEGER_MAX = new BigDecimal(Integer.MAX_VALUE);
    public static final BigDecimal BIG_DECIMAL_INTEGER_MIN = new BigDecimal(Integer.MIN_VALUE);
    public static final Integer LESS = -1;
    public static final Integer MORE = 1;

    private OperatorOfNumber() {
        throw new IllegalStateException("Utility class");
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(v);
        BigDecimal oneBigDecimal = new BigDecimal("1");
        return bigDecimal.divide(oneBigDecimal, scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static int getSeq(Class<?> clazz) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return 1;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return 2;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return 3;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return 4;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return 5;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return 6;
        }
        if (clazz == BigDecimal.class) {
            return 7;
        }
        throw new RuntimeException("\u4e0d\u80fd\u5904\u7406\u7684\u6570\u636e\u7c7b\u578b\uff1a" + clazz.getName());
    }

    public static Number transfer(Number value, Class<?> type, boolean isForce) {
        if (isForce || !(value instanceof BigDecimal)) {
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return value.byteValue();
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return value.shortValue();
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return value.intValue();
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return value.longValue();
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return Float.valueOf(value.floatValue());
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return value.doubleValue();
            }
            if (type.equals(BigDecimal.class)) {
                return new BigDecimal(value.toString());
            }
            throw new RuntimeException("\u6ca1\u6709\u5904\u7406\u7684\u6570\u636e\u7c7b\u578b\uff1a" + type.getName());
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            if (((BigDecimal)value).scale() > 0) {
                throw new RuntimeException("\u6709\u5c0f\u6570\u4f4d\uff0c\u4e0d\u80fd\u8f6c\u5316\u4e3a\uff1a" + type.getName());
            }
            return value.byteValue();
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            if (((BigDecimal)value).scale() > 0) {
                throw new RuntimeException("\u6709\u5c0f\u6570\u4f4d\uff0c\u4e0d\u80fd\u8f6c\u5316\u4e3a\uff1a" + type.getName());
            }
            return value.shortValue();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            if (((BigDecimal)value).scale() > 0) {
                throw new RuntimeException("\u6709\u5c0f\u6570\u4f4d\uff0c\u4e0d\u80fd\u8f6c\u5316\u4e3a\uff1a" + type.getName());
            }
            return value.intValue();
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            if (((BigDecimal)value).scale() > 0) {
                throw new RuntimeException("\u6709\u5c0f\u6570\u4f4d\uff0c\u4e0d\u80fd\u8f6c\u5316\u4e3a\uff1a" + type.getName());
            }
            return value.longValue();
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(value.floatValue());
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return value.doubleValue();
        }
        throw new RuntimeException("\u6ca1\u6709\u5904\u7406\u7684\u6570\u636e\u7c7b\u578b\uff1a" + type.getName());
    }

    public static int compareNumber(Number op1, Number op2) {
        int type2;
        int type1 = OperatorOfNumber.getSeq(op1.getClass());
        int type = Math.max(type1, type2 = OperatorOfNumber.getSeq(op2.getClass()));
        if (type == 1) {
            byte o1 = op1.byteValue();
            byte o2 = op2.byteValue();
            return Byte.compare(o1, o2);
        }
        if (type == 2) {
            short o1 = op1.shortValue();
            short o2 = op2.shortValue();
            return Short.compare(o1, o2);
        }
        if (type == 3) {
            int o1 = op1.intValue();
            int o2 = op2.intValue();
            return Integer.compare(o1, o2);
        }
        if (type == 4) {
            long o1 = op1.longValue();
            long o2 = op2.longValue();
            return Long.compare(o1, o2);
        }
        if (type == 5) {
            float o1 = op1.floatValue();
            float o2 = op2.floatValue();
            return Float.compare(o1, o2);
        }
        if (type == 6) {
            double o1 = op1.doubleValue();
            double o2 = op2.doubleValue();
            return Double.compare(o1, o2);
        }
        if (type == 7) {
            BigDecimal o1 = new BigDecimal(op1.toString());
            BigDecimal o2 = new BigDecimal(op2.toString());
            return o1.compareTo(o2);
        }
        throw new RuntimeException("\u6bd4\u8f83\u64cd\u4f5c\u9519\u8bef:op1=" + op1 + ",op2=" + op2);
    }

    public static Object add(Object op1, Object op2, boolean isPrecise) throws Exception {
        if (op1 == null) {
            op1 = "null";
        }
        if (op2 == null) {
            op2 = "null";
        }
        if (op1 instanceof String || op2 instanceof String) {
            return op1.toString() + op2;
        }
        if (isPrecise) {
            return PreciseNumberOperator.addPrecise((Number)op1, (Number)op2);
        }
        return NormalNumberOperator.addNormal((Number)op1, (Number)op2);
    }

    public static Number subtract(Object op1, Object op2, boolean isPrecise) throws Exception {
        if (isPrecise) {
            return PreciseNumberOperator.subtractPrecise((Number)op1, (Number)op2);
        }
        return NormalNumberOperator.subtractNormal((Number)op1, (Number)op2);
    }

    public static Number multiply(Object op1, Object op2, boolean isPrecise) throws Exception {
        if (isPrecise) {
            return PreciseNumberOperator.multiplyPrecise((Number)op1, (Number)op2);
        }
        return NormalNumberOperator.multiplyNormal((Number)op1, (Number)op2);
    }

    public static Number divide(Object op1, Object op2, boolean isPrecise) throws Exception {
        if (isPrecise) {
            return PreciseNumberOperator.dividePrecise((Number)op1, (Number)op2);
        }
        return NormalNumberOperator.divideNormal((Number)op1, (Number)op2);
    }

    public static Object modulo(Object op1, Object op2) throws Exception {
        return NormalNumberOperator.moduloNormal((Number)op1, (Number)op2);
    }
}

