/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.OperatorOfNumber;
import com.ql.util.express.QLambda;
import com.ql.util.express.QLambdaInvocationHandler;
import com.ql.util.express.annotation.QLAlias;
import com.ql.util.express.config.QLExpressRunStrategy;
import com.ql.util.express.exception.QLException;
import com.ql.util.express.util.QLAliasUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressUtil {
    private static final Pattern PATTERN = Pattern.compile("\\$\\d+");
    public static final String DT_STRING = "String";
    public static final String DT_SHORT = "Short";
    public static final String DT_INTEGER = "Integer";
    public static final String DT_LONG = "Long";
    public static final String DT_DOUBLE = "Double";
    public static final String DT_FLOAT = "Float";
    public static final String DT_BYTE = "Byte";
    public static final String DT_CHAR = "Char";
    public static final String DT_BOOLEAN = "Boolean";
    public static final String DT_DATE = "Date";
    public static final String DT_TIME = "Time";
    public static final String DT_DATETIME = "DateTime";
    public static final String DT_OBJECT = "Object";
    public static final String DT_short = "short";
    public static final String DT_int = "int";
    public static final String DT_long = "long";
    public static final String DT_double = "double";
    public static final String DT_float = "float";
    public static final String DT_byte = "byte";
    public static final String DT_char = "char";
    public static final String DT_boolean = "boolean";
    private static final Map<String, Object> METHOD_CACHE = new ConcurrentHashMap<String, Object>();
    private static final Class<?>[][] CLASS_MATCHES = new Class[][]{{BigDecimal.class, Double.TYPE}, {BigDecimal.class, Float.TYPE}, {BigDecimal.class, Long.TYPE}, {BigDecimal.class, Integer.TYPE}, {BigDecimal.class, Short.TYPE}, {BigDecimal.class, Byte.TYPE}, {Double.TYPE, Float.TYPE}, {Double.TYPE, Long.TYPE}, {Double.TYPE, Integer.TYPE}, {Double.TYPE, Short.TYPE}, {Double.TYPE, Byte.TYPE}, {Double.TYPE, BigDecimal.class}, {Float.TYPE, Long.TYPE}, {Float.TYPE, Integer.TYPE}, {Float.TYPE, Short.TYPE}, {Float.TYPE, Byte.TYPE}, {Float.TYPE, BigDecimal.class}, {Long.TYPE, Integer.TYPE}, {Long.TYPE, Short.TYPE}, {Long.TYPE, Byte.TYPE}, {Integer.TYPE, Short.TYPE}, {Integer.TYPE, Byte.TYPE}, {Short.TYPE, Byte.TYPE}, {Character.TYPE, Character.class}, {Character.class, Character.TYPE}, {Boolean.TYPE, Boolean.class}, {Boolean.class, Boolean.TYPE}};
    private static final Map<Class<?>, Boolean> IS_FUNCTION_INTERFACE_CACHE = new ConcurrentHashMap();

    private ExpressUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Class<?> getSimpleDataType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (Integer.class.equals(clazz)) {
            return Integer.TYPE;
        }
        if (Short.class.equals(clazz)) {
            return Short.TYPE;
        }
        if (Long.class.equals(clazz)) {
            return Long.TYPE;
        }
        if (Double.class.equals(clazz)) {
            return Double.TYPE;
        }
        if (Float.class.equals(clazz)) {
            return Float.TYPE;
        }
        if (Byte.class.equals(clazz)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(clazz)) {
            return Character.TYPE;
        }
        if (Boolean.class.equals(clazz)) {
            return Boolean.TYPE;
        }
        return clazz;
    }

    public static boolean isAssignable(Class<?> target, Class<?> source) {
        if (target == source) {
            return true;
        }
        if (target.isArray() && source.isArray()) {
            return ExpressUtil.isAssignable(target.getComponentType(), source.getComponentType());
        }
        return ExpressUtil.isAssignablePrivate(target, source);
    }

    public static boolean isAssignablePrivate(Class<?> target, Class<?> source) {
        if (target == source) {
            return true;
        }
        if (target == null) {
            return false;
        }
        if (source == null) {
            return !target.isPrimitive();
        }
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (source.isPrimitive() && target == Object.class) {
            return true;
        }
        if (!target.isPrimitive()) {
            if (target == Byte.class) {
                target = Byte.TYPE;
            } else if (target == Short.class) {
                target = Short.TYPE;
            } else if (target == Integer.class) {
                target = Integer.TYPE;
            } else if (target == Long.class) {
                target = Long.TYPE;
            } else if (target == Float.class) {
                target = Float.TYPE;
            } else if (target == Double.class) {
                target = Double.TYPE;
            }
        }
        if (!source.isPrimitive()) {
            if (source == Byte.class) {
                source = Byte.TYPE;
            } else if (source == Short.class) {
                source = Short.TYPE;
            } else if (source == Integer.class) {
                source = Integer.TYPE;
            } else if (source == Long.class) {
                source = Long.TYPE;
            } else if (source == Float.class) {
                source = Float.TYPE;
            } else if (source == Double.class) {
                source = Double.TYPE;
            }
        }
        if (target == source) {
            return true;
        }
        if (source == QLambda.class && ExpressUtil.isFunctionInterface(target)) {
            return true;
        }
        for (Class<?>[] classMatch : CLASS_MATCHES) {
            if (target != classMatch[0] || source != classMatch[1]) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableOld(Class<?> lhsType, Class<?> rhsType) {
        if (lhsType == null) {
            return false;
        }
        if (rhsType == null) {
            return !lhsType.isPrimitive();
        }
        if (lhsType.isPrimitive() && rhsType.isPrimitive()) {
            if (lhsType == rhsType) {
                return true;
            }
            if (rhsType == Byte.TYPE && (lhsType == Short.TYPE || lhsType == Integer.TYPE || lhsType == Long.TYPE || lhsType == Float.TYPE || lhsType == Double.TYPE)) {
                return true;
            }
            if (rhsType == Short.TYPE && (lhsType == Integer.TYPE || lhsType == Long.TYPE || lhsType == Float.TYPE || lhsType == Double.TYPE)) {
                return true;
            }
            if (rhsType == Character.TYPE && (lhsType == Integer.TYPE || lhsType == Long.TYPE || lhsType == Float.TYPE || lhsType == Double.TYPE)) {
                return true;
            }
            if (rhsType == Integer.TYPE && (lhsType == Long.TYPE || lhsType == Float.TYPE || lhsType == Double.TYPE)) {
                return true;
            }
            if (rhsType == Long.TYPE && (lhsType == Float.TYPE || lhsType == Double.TYPE)) {
                return true;
            }
            return rhsType == Float.TYPE && lhsType == Double.TYPE;
        }
        return lhsType.isAssignableFrom(rhsType);
    }

    public static boolean isSignatureAssignable(Class<?>[] from, Class<?>[] to) {
        for (int i = 0; i < from.length; ++i) {
            if (ExpressUtil.isAssignable(to[i], from[i])) continue;
            return false;
        }
        return true;
    }

    public static int findMostSpecificSignature(Class<?>[] idealMatch, Class<?>[][] candidates) {
        Class<?>[] bestMatch = null;
        int bestMatchIndex = -1;
        for (int i = candidates.length - 1; i >= 0; --i) {
            Class<?>[] targetMatch = candidates[i];
            if (!ExpressUtil.isSignatureAssignable(idealMatch, targetMatch) || bestMatch != null && !ExpressUtil.isSignatureAssignable(targetMatch, bestMatch)) continue;
            bestMatch = targetMatch;
            bestMatchIndex = i;
        }
        if (bestMatch != null) {
            return bestMatchIndex;
        }
        return -1;
    }

    public static String createCacheKey(Class<?> baseClass, String methodName, Class<?>[] types, boolean publicOnly, boolean isStatic) {
        StringBuilder builder = new StringBuilder();
        builder.append(baseClass.getName()).append(".").append(methodName).append(".");
        if (types == null) {
            builder.append("null");
        } else {
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                if (types[i] == null) {
                    builder.append("null");
                    continue;
                }
                builder.append(types[i].getName());
            }
        }
        return builder.toString();
    }

    public static Method findMethodWithCache(Class<?> baseClass, String methodName, Class<?>[] types, boolean publicOnly, boolean isStatic) {
        String key = ExpressUtil.createCacheKey(baseClass, methodName, types, publicOnly, isStatic);
        Object result = METHOD_CACHE.get(key);
        if (result == null) {
            result = ExpressUtil.findMethod(baseClass, methodName, types, publicOnly, isStatic);
            if (result == null) {
                METHOD_CACHE.put(key, Void.TYPE);
            } else {
                ((Method)result).setAccessible(true);
                METHOD_CACHE.put(key, result);
            }
        } else if (result == Void.TYPE) {
            result = null;
        }
        return (Method)result;
    }

    public static Method findMethod(Class<?> baseClass, String methodName, Class<?>[] types, boolean publicOnly, boolean isStatic) {
        List<Method> candidates = ExpressUtil.gatherMethodsRecursive(baseClass, methodName, types.length, publicOnly, isStatic, null);
        return ExpressUtil.findMostSpecificMethod(types, candidates.toArray(new Method[0]));
    }

    public static Constructor<?> findConstructorWithCache(Class<?> baseClass, Class<?>[] types) {
        String key = ExpressUtil.createCacheKey(baseClass, "new", types, true, false);
        Constructor<?> result = (Constructor<?>)METHOD_CACHE.get(key);
        if (result == null) {
            result = ExpressUtil.findConstructor(baseClass, types);
            METHOD_CACHE.put(key, result);
        }
        return result;
    }

    private static Constructor<?> findConstructor(Class<?> baseClass, Class<?>[] types) {
        Constructor<?>[] constructors = baseClass.getConstructors();
        ArrayList constructorList = new ArrayList();
        ArrayList<Class<?>[]> listClass = new ArrayList<Class<?>[]>();
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length != types.length) continue;
            listClass.add(constructor.getParameterTypes());
            constructorList.add(constructor);
        }
        int match = ExpressUtil.findMostSpecificSignature(types, (Class[][])listClass.toArray((T[])new Class[0][]));
        return match == -1 ? null : (Constructor)constructorList.get(match);
    }

    public static Method findMostSpecificMethod(Class<?>[] idealMatch, Method[] methods) {
        Class[][] candidateSigs = new Class[methods.length][];
        for (int i = 0; i < methods.length; ++i) {
            candidateSigs[i] = methods[i].getParameterTypes();
        }
        int match = ExpressUtil.findMostSpecificSignature(idealMatch, candidateSigs);
        return match == -1 ? null : methods[match];
    }

    private static List<Method> gatherMethodsRecursive(Class<?> baseClass, String methodName, int numArgs, boolean publicOnly, boolean isStatic, List<Method> candidates) {
        Class<?>[] interfaces;
        if (candidates == null) {
            candidates = new ArrayList<Method>();
        }
        ExpressUtil.addCandidates(baseClass.getDeclaredMethods(), methodName, numArgs, publicOnly, isStatic, candidates);
        for (Class<?> anInterface : interfaces = baseClass.getInterfaces()) {
            ExpressUtil.gatherMethodsRecursive(anInterface, methodName, numArgs, publicOnly, isStatic, candidates);
        }
        Class<?> superclass = baseClass.getSuperclass();
        if (superclass != null) {
            ExpressUtil.gatherMethodsRecursive(superclass, methodName, numArgs, publicOnly, isStatic, candidates);
        }
        return candidates;
    }

    private static List<Method> addCandidates(Method[] methods, String methodName, int numArgs, boolean publicOnly, boolean isStatic, List<Method> candidates) {
        for (Method m : methods) {
            String[] values;
            if (m.getName().equals(methodName) && m.getParameterTypes().length == numArgs && (!publicOnly || ExpressUtil.isPublic(m) && (!isStatic || ExpressUtil.isStatic(m)))) {
                candidates.add(m);
                continue;
            }
            if (!m.isAnnotationPresent(QLAlias.class) || (values = m.getAnnotation(QLAlias.class).value()).length <= 0) continue;
            for (String value : values) {
                if (!value.equals(methodName) || m.getParameterTypes().length != numArgs || publicOnly && (!ExpressUtil.isPublic(m) || isStatic && !ExpressUtil.isStatic(m))) continue;
                candidates.add(m);
            }
        }
        return candidates;
    }

    public static boolean isPublic(Class<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    public static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static Class<?> getJavaClass(String type) {
        int index = type.indexOf("[]");
        if (index < 0) {
            return ExpressUtil.getJavaClassInner(type);
        }
        StringBuilder arrayString = new StringBuilder();
        arrayString.append("[");
        String baseType = type.substring(0, index);
        while ((index = type.indexOf("[]", index + 2)) >= 0) {
            arrayString.append("[");
        }
        Class<?> baseClass = ExpressUtil.getJavaClassInner(baseType);
        try {
            String baseName = "";
            if (!baseClass.isPrimitive()) {
                return ExpressUtil.loadClass(arrayString + "L" + baseClass.getName() + ";");
            }
            if (baseClass.equals(Boolean.TYPE)) {
                baseName = "Z";
            } else if (baseClass.equals(Byte.TYPE)) {
                baseName = "B";
            } else if (baseClass.equals(Character.TYPE)) {
                baseName = "C";
            } else if (baseClass.equals(Double.TYPE)) {
                baseName = "D";
            } else if (baseClass.equals(Float.TYPE)) {
                baseName = "F";
            } else if (baseClass.equals(Integer.TYPE)) {
                baseName = "I";
            } else if (baseClass.equals(Long.TYPE)) {
                baseName = "J";
            } else if (baseClass.equals(Short.TYPE)) {
                baseName = "S";
            }
            return ExpressUtil.loadClass(arrayString + baseName);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> getJavaClassInner(String type) {
        if (type.equals(DT_STRING)) {
            return String.class;
        }
        if (type.equals(DT_SHORT)) {
            return Short.class;
        }
        if (type.equals(DT_INTEGER)) {
            return Integer.class;
        }
        if (type.equals(DT_LONG)) {
            return Long.class;
        }
        if (type.equals(DT_DOUBLE)) {
            return Double.class;
        }
        if (type.equals(DT_FLOAT)) {
            return Float.class;
        }
        if (type.equals(DT_BYTE)) {
            return Byte.class;
        }
        if (type.equals(DT_CHAR) || "Character".equals(type)) {
            return Character.class;
        }
        if (type.equals(DT_BOOLEAN)) {
            return Boolean.class;
        }
        if (type.equals(DT_DATE)) {
            return Date.class;
        }
        if (type.equals(DT_TIME)) {
            return Time.class;
        }
        if (type.equals(DT_DATETIME)) {
            return Timestamp.class;
        }
        if (type.equals(DT_OBJECT)) {
            return Object.class;
        }
        if (type.equals(DT_short)) {
            return Short.TYPE;
        }
        if (type.equals(DT_int)) {
            return Integer.TYPE;
        }
        if (type.equals(DT_long)) {
            return Long.TYPE;
        }
        if (type.equals(DT_double)) {
            return Double.TYPE;
        }
        if (type.equals(DT_float)) {
            return Float.TYPE;
        }
        if (type.equals(DT_byte)) {
            return Byte.TYPE;
        }
        if (type.equals(DT_char)) {
            return Character.TYPE;
        }
        if (type.equals(DT_boolean)) {
            return Boolean.TYPE;
        }
        try {
            return ExpressUtil.loadClass(type);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getClassName(Class<?> className) {
        if (className == null) {
            return null;
        }
        String name = className.getName();
        return ExpressUtil.getClassName(name);
    }

    private static String getClassName(String name) {
        int index;
        StringBuilder arrays = new StringBuilder();
        if (name.contains("[")) {
            int point = 0;
            while (name.charAt(point) == '[') {
                arrays.append("[]");
                ++point;
            }
            if (name.charAt(point) == 'L') {
                name = name.substring(point + 1, name.length() - 1);
            } else if (name.charAt(point) == 'Z') {
                name = DT_boolean;
            } else if (name.charAt(point) == 'B') {
                name = DT_byte;
            } else if (name.charAt(point) == 'C') {
                name = DT_char;
            } else if (name.charAt(point) == 'D') {
                name = DT_double;
            } else if (name.charAt(point) == 'F') {
                name = DT_float;
            } else if (name.charAt(point) == 'I') {
                name = DT_int;
            } else if (name.charAt(point) == 'J') {
                name = DT_long;
            } else if (name.charAt(point) == 'S') {
                name = DT_short;
            }
        }
        if ((index = name.lastIndexOf(46)) > 0 && "java.lang".equals(name.substring(0, index))) {
            name = name.substring(index + 1);
        }
        name = name + arrays;
        return name;
    }

    public static Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader customClassLoader = QLExpressRunStrategy.getCustomClassLoader();
        if (customClassLoader != null) {
            return Class.forName(name, true, customClassLoader);
        }
        return Class.forName(name);
    }

    public static String replaceString(String str, Object[] parameters) throws Exception {
        if (str == null || parameters == null || parameters.length == 0) {
            return str;
        }
        Matcher m = PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int index = Integer.parseInt(m.group().substring(1)) - 1;
            if (index < 0 || index >= parameters.length) {
                throw new QLException("\u8bbe\u7f6e\u7684\u53c2\u6570\u4f4d\u7f6e$" + (index + 1) + "\u8d85\u8fc7\u4e86\u8303\u56f4 " + parameters.length);
            }
            m.appendReplacement(sb, " " + parameters[index].toString() + " ");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static Object getProperty(Object bean, Object name) {
        try {
            if (bean == null && QLExpressRunStrategy.isAvoidNullPointer()) {
                return null;
            }
            if (bean == null) {
                throw new QLException("\u5bf9\u8c61\u4e3a\u7a7a,\u4e0d\u80fd\u83b7\u53d6\u5c5e\u6027:" + name);
            }
            if (bean.getClass().isArray() && "length".equals(name)) {
                return Array.getLength(bean);
            }
            if (bean instanceof Class) {
                if ("class".equals(name)) {
                    return bean;
                }
                if (QLExpressRunStrategy.isSandboxMode()) {
                    throw new QLException("\u65e0\u6cd5\u83b7\u53d6\u5c5e\u6027:" + name);
                }
                Field f = ((Class)bean).getDeclaredField(name.toString());
                return f.get(null);
            }
            if (bean instanceof Map) {
                return ((Map)bean).get(name);
            }
            if (QLExpressRunStrategy.isSandboxMode()) {
                throw new QLException("\u65e0\u6cd5\u83b7\u53d6\u5c5e\u6027:" + name);
            }
            return QLAliasUtils.getProperty(bean, name.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getPropertyClass(Object bean, Object name) {
        try {
            if (bean.getClass().isArray() && "length".equals(name)) {
                return Integer.TYPE;
            }
            if (bean instanceof Class) {
                if ("class".equals(name)) {
                    return Class.class;
                }
                Field f = ((Class)bean).getDeclaredField(name.toString());
                return f.getType();
            }
            if (bean instanceof Map) {
                Object o = ((Map)bean).get(name);
                if (o == null) {
                    return null;
                }
                return o.getClass();
            }
            return QLAliasUtils.getPropertyClass(bean, name.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setProperty(Object bean, Object name, Object value) {
        try {
            if (bean instanceof Class) {
                Field field = ((Class)bean).getDeclaredField(name.toString());
                field.set(null, value);
            } else if (bean instanceof Map) {
                ((Map)bean).put(name, value);
            } else {
                QLAliasUtils.setProperty(bean, name.toString(), value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0d\u80fd\u8bbf\u95ee" + bean + "\u7684property:" + name, e);
        }
    }

    public static Object[] transferArray(Object[] values, Class<?>[] types) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = ExpressUtil.castObject(values[i], types[i], false);
        }
        return values;
    }

    public static Object castObject(Object value, Class<?> type, boolean isForce) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == type || type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof Number && (type.isPrimitive() || Number.class.isAssignableFrom(type))) {
            return OperatorOfNumber.transfer((Number)value, type, isForce);
        }
        if (type.isArray() && value.getClass().isArray()) {
            Class<?> valueType = value.getClass().getComponentType();
            Class<?> declareType = type.getComponentType();
            if (declareType != valueType) {
                Object[] values = (Object[])value;
                boolean allBlank = true;
                for (Object o : values) {
                    if (o == null) continue;
                    allBlank = false;
                    break;
                }
                if (allBlank) {
                    return Array.newInstance(declareType, values.length);
                }
            }
            return value;
        }
        if (value.getClass() == QLambda.class && ExpressUtil.isFunctionInterface(type)) {
            return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new QLambdaInvocationHandler((QLambda)value));
        }
        return value;
    }

    private static boolean isFunctionInterface(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        Boolean cacheRes = IS_FUNCTION_INTERFACE_CACHE.get(clazz);
        if (cacheRes != null) {
            return cacheRes;
        }
        boolean res = clazz.isInterface() && ExpressUtil.hasOnlyOneAbstractMethod(clazz.getMethods());
        IS_FUNCTION_INTERFACE_CACHE.put(clazz, res);
        return res;
    }

    private static boolean hasOnlyOneAbstractMethod(Method[] methods) {
        int count = 0;
        for (Method method : methods) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            ++count;
        }
        return count == 1;
    }
}

