/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.dubbo.context.event;

import com.alibaba.boot.dubbo.util.DubboUtils;
import com.alibaba.dubbo.common.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;

@Order(value=-2147483627)
public class WelcomeLogoApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        String bannerText = this.buildBannerText();
        if (logger.isInfoEnabled()) {
            logger.info(bannerText);
        } else {
            System.out.print(bannerText);
        }
    }

    String buildBannerText() {
        StringBuilder bannerTextBuilder = new StringBuilder();
        bannerTextBuilder.append(DubboUtils.LINE_SEPARATOR).append(DubboUtils.LINE_SEPARATOR).append(" :: Dubbo Spring Boot (v").append(Version.getVersion(this.getClass(), (String)"1.0.0")).append(") : ").append("https://github.com/apache/incubator-dubbo-spring-boot-project").append(DubboUtils.LINE_SEPARATOR).append(" :: Dubbo (v").append(Version.getVersion()).append(") : ").append("https://github.com/apache/incubator-dubbo").append(DubboUtils.LINE_SEPARATOR).append(" :: Google group : ").append("dev@dubbo.incubator.apache.org").append(DubboUtils.LINE_SEPARATOR);
        return bannerTextBuilder.toString();
    }
}

