/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.logging;

import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.nacos.client.logging.NacosLogging;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

public class NacosLoggingListener
implements GenericApplicationListener {
    public boolean supportsEventType(ResolvableType resolvableType) {
        Class type = resolvableType.getRawClass();
        if (type != null) {
            return ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(type);
        }
        return false;
    }

    public boolean supportsSourceType(Class<?> aClass) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        ApplicationEnvironmentPreparedEvent applicationEnvironmentPreparedEvent = (ApplicationEnvironmentPreparedEvent)applicationEvent;
        NacosConfigProperties nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(applicationEnvironmentPreparedEvent.getEnvironment());
        if (nacosConfigProperties.getBootstrap().isLogEnable()) {
            NacosLogging.getInstance().loadConfiguration();
        }
    }

    public int getOrder() {
        return -2147483627;
    }
}

