/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.web.condition;

import com.alibaba.boot.web.condition.ConditionalOnPropertyPrefix;
import java.util.Arrays;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnPropertyPrefixCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConditionalOnPropertyPrefix.class.getName()));
        String[] prefixValues = annotationAttributes.getStringArray("value");
        ConfigurableEnvironment environment = (ConfigurableEnvironment)context.getEnvironment();
        boolean matched = false;
        for (String prefix : prefixValues) {
            if (!this.startsWith(environment, prefix)) continue;
            matched = true;
            break;
        }
        return matched ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)("The prefix values " + Arrays.asList(prefixValues) + " were not found in Environment!"));
    }

    private boolean startsWith(ConfigurableEnvironment environment, String prefix) {
        String actualPrefix = prefix.endsWith(".") ? prefix : prefix + ".";
        boolean started = false;
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        block0: for (PropertySource propertySource : mutablePropertySources) {
            String[] propertyNames;
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource source = (EnumerablePropertySource)EnumerablePropertySource.class.cast(propertySource);
            for (String propertyName : propertyNames = source.getPropertyNames()) {
                if (!propertyName.startsWith(actualPrefix)) continue;
                started = true;
                continue block0;
            }
        }
        return started;
    }
}

