/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.autoconfigure;

import com.alibaba.boot.velocity.VelocityLayoutProperties;
import com.alibaba.boot.velocity.autoconfigure.condition.VelocityLayoutCondition;
import com.alibaba.boot.velocity.web.servlet.VelocityLayoutHandlerInterceptor;
import com.alibaba.boot.velocity.web.servlet.view.EmbeddedVelocityLayoutViewResolver;
import javax.servlet.Servlet;
import org.apache.velocity.app.VelocityEngine;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.velocity.VelocityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.ui.velocity.VelocityEngineFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.velocity.VelocityConfigurer;
import org.springframework.web.servlet.view.velocity.VelocityViewResolver;

@Configuration
@ConditionalOnClass(value={VelocityEngine.class, VelocityEngineFactory.class})
@Conditional(value={VelocityLayoutCondition.class})
@AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration", "org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration"})
@AutoConfigureBefore(value={VelocityAutoConfiguration.class})
public class VelocityLayoutAutoConfiguration {

    static final class VelocityLayoutWebMvcConfigurer
    extends WebMvcConfigurerAdapter {
        private final VelocityLayoutProperties velocityLayoutProperties;

        private VelocityLayoutWebMvcConfigurer(VelocityLayoutProperties velocityLayoutProperties) {
            this.velocityLayoutProperties = velocityLayoutProperties;
        }

        public void addInterceptors(InterceptorRegistry registry) {
            VelocityLayoutHandlerInterceptor velocityLayoutHandlerInterceptor = new VelocityLayoutHandlerInterceptor(this.velocityLayoutProperties.getLayoutKey());
            registry.addInterceptor((HandlerInterceptor)velocityLayoutHandlerInterceptor);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, VelocityConfigurer.class})
    @ConditionalOnWebApplication
    @Conditional(value={VelocityLayoutCondition.class})
    public static class VelocityLayoutWebConfiguration {
        @Primary
        @Bean
        @ConditionalOnMissingBean(value={VelocityLayoutProperties.class})
        public VelocityLayoutProperties velocityLayoutProperties() {
            return new VelocityLayoutProperties();
        }

        @Bean(name={"velocityViewResolver"})
        @ConditionalOnMissingBean(value={VelocityViewResolver.class})
        public EmbeddedVelocityLayoutViewResolver embeddedVelocityLayoutViewResolver(VelocityLayoutProperties velocityLayoutProperties) {
            EmbeddedVelocityLayoutViewResolver resolver = new EmbeddedVelocityLayoutViewResolver();
            velocityLayoutProperties.applyToViewResolver((Object)resolver);
            return resolver;
        }

        @Bean
        public VelocityLayoutWebMvcConfigurer velocityLayoutWebMvcConfigurer(VelocityLayoutProperties velocityLayoutProperties) {
            return new VelocityLayoutWebMvcConfigurer(velocityLayoutProperties);
        }
    }
}

