/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.velocity.beans.factory.support;

import com.alibaba.boot.velocity.tools.VelocityTool;
import com.alibaba.boot.velocity.tools.VelocityToolsRepository;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.core.Ordered;

public class VelocityToolsBeanDefinitionRegistryPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanDefinitionRegistryPostProcessor,
ServletContextInitializer,
Ordered {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final VelocityToolsRepository velocityToolsRepository;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    public VelocityToolsBeanDefinitionRegistryPostProcessor(VelocityToolsRepository velocityToolsRepository) {
        this.velocityToolsRepository = velocityToolsRepository;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.beanDefinitionRegistry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void onStartup(ServletContext servletContext) throws ServletException {
        Map<String, VelocityTool> velocityToolsMap = this.velocityToolsRepository.findAll();
        for (Map.Entry<String, VelocityTool> entry : velocityToolsMap.entrySet()) {
            String beanName = entry.getKey();
            VelocityTool velocityTool = entry.getValue();
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((Class)velocityTool.getToolClass());
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            if (this.beanDefinitionRegistry.containsBeanDefinition(beanName)) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Bean[name : " + beanName + "] was existed in ApplicationContext , thus velocity tool bean[" + beanDefinition.getBeanClassName() + "] will not be registered !"));
                continue;
            }
            this.beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

