/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.generictype.impl;

import com.alibaba.citrus.generictype.ClassTypeInfo;
import com.alibaba.citrus.generictype.GenericDeclarationInfo;
import com.alibaba.citrus.generictype.MethodInfo;
import com.alibaba.citrus.generictype.TypeInfo;
import com.alibaba.citrus.generictype.TypeVariableInfo;
import com.alibaba.citrus.generictype.codegen.MethodSignature;
import com.alibaba.citrus.generictype.codegen.TypeUtil;
import com.alibaba.citrus.generictype.impl.AbstractGenericDeclarationInfo;
import com.alibaba.citrus.util.CollectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodImpl
extends AbstractGenericDeclarationInfo
implements MethodInfo {
    private static final int MODIFIERS_MASK = 15;
    private final MethodSignature signature;
    private final int modifiers;
    private ClassTypeInfo declaringType;
    private TypeInfo returnType;
    private List<TypeInfo> parameterTypes;
    private List<TypeInfo> exceptionTypes;
    private List<TypeInfo> effectiveExceptionTypes;

    MethodImpl(Method method) {
        super(method);
        this.signature = TypeUtil.getMethodSignature(method);
        this.modifiers = method.getModifiers() & 0xF;
    }

    MethodImpl(Constructor<?> constructor) {
        super(constructor);
        this.signature = TypeUtil.getConstructorSignature(constructor);
        this.modifiers = constructor.getModifiers() & 0xF;
    }

    void init(TypeVariableInfo[] vars, TypeInfo returnType, TypeInfo[] parameterTypes, TypeInfo[] exceptionTypes, ClassTypeInfo declaringType) {
        super.init(vars);
        this.declaringType = declaringType;
        this.returnType = returnType;
        this.parameterTypes = Collections.unmodifiableList(CollectionUtil.asList(parameterTypes));
        this.exceptionTypes = Collections.unmodifiableList(CollectionUtil.asList(exceptionTypes));
        this.effectiveExceptionTypes = this.getEffectiveExceptionTypes(exceptionTypes);
    }

    private List<TypeInfo> getEffectiveExceptionTypes(TypeInfo[] exceptionTypes) {
        ArrayList effectiveExceptions = CollectionUtil.createArrayList(exceptionTypes.length);
        for (TypeInfo exception : exceptionTypes) {
            if (RuntimeException.class.isAssignableFrom(exception.getRawType()) || Error.class.isAssignableFrom(exception.getRawType())) continue;
            Iterator j = effectiveExceptions.iterator();
            while (j.hasNext()) {
                TypeInfo existing = (TypeInfo)j.next();
                if (exception.getRawType().isAssignableFrom(existing.getRawType())) {
                    j.remove();
                    continue;
                }
                if (!existing.getRawType().isAssignableFrom(exception.getRawType())) continue;
                exception = null;
                break;
            }
            if (exception == null) continue;
            effectiveExceptions.add(exception);
        }
        effectiveExceptions.trimToSize();
        return Collections.unmodifiableList(effectiveExceptions);
    }

    @Override
    public boolean isConstructor() {
        return this.declaration instanceof Constructor;
    }

    @Override
    public Constructor<?> getConstructor() {
        if (this.isConstructor()) {
            return (Constructor)this.declaration;
        }
        return null;
    }

    @Override
    public Method getMethod() {
        if (!this.isConstructor()) {
            return (Method)this.declaration;
        }
        return null;
    }

    @Override
    public TypeInfo getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public TypeInfo getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.signature.getName();
    }

    @Override
    public List<TypeInfo> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public List<TypeInfo> getExceptionTypes() {
        return this.exceptionTypes;
    }

    @Override
    public List<TypeInfo> getEffectiveExceptionTypes() {
        return this.effectiveExceptionTypes;
    }

    @Override
    public MethodInfo resolve(GenericDeclarationInfo context) {
        return this.resolve(context, true);
    }

    @Override
    public MethodInfo resolve(GenericDeclarationInfo context, boolean includeBaseType) {
        MethodImpl resolvedMethod;
        if (context == null) {
            context = this.declaringType;
        }
        boolean changed = false;
        TypeInfo[] parameterTypes = new TypeInfo[this.parameterTypes.size()];
        TypeInfo[] exceptionTypes = new TypeInfo[this.exceptionTypes.size()];
        changed |= this.resolveTypes(this.parameterTypes, parameterTypes, context, includeBaseType);
        changed |= this.resolveTypes(this.exceptionTypes, exceptionTypes, context, includeBaseType);
        TypeInfo returnType = this.returnType.resolve(context, includeBaseType);
        if (returnType != this.returnType) {
            changed = true;
        }
        if (changed) {
            resolvedMethod = this.isConstructor() ? new MethodImpl(this.getConstructor()) : new MethodImpl(this.getMethod());
            TypeVariableInfo[] vars = this.getTypeParameters().toArray(new TypeVariableInfo[this.getTypeParameters().size()]);
            resolvedMethod.init(vars, returnType, parameterTypes, exceptionTypes, this.declaringType);
        } else {
            resolvedMethod = this;
        }
        return resolvedMethod;
    }

    private boolean resolveTypes(List<TypeInfo> types, TypeInfo[] resolvedTypes, GenericDeclarationInfo context, boolean includeBaseType) {
        boolean changed = false;
        for (int i = 0; i < resolvedTypes.length; ++i) {
            TypeInfo resolvedType;
            TypeInfo type = types.get(i);
            if (type != (resolvedType = type.resolve(context, includeBaseType))) {
                changed = true;
            }
            resolvedTypes[i] = resolvedType;
        }
        return changed;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.appendIfNotEmpty(buf, Modifier.toString(this.modifiers), " ");
        if (this.appendTypeParameters(buf) > 0) {
            buf.append(" ");
        }
        if (!this.isConstructor()) {
            buf.append(this.returnType).append(" ");
            buf.append(this.declaringType.getSimpleName());
            buf.append(".").append(this.getName());
        } else {
            buf.append(this.declaringType.getSimpleName());
        }
        buf.append("(");
        CollectionUtil.join(buf, this.parameterTypes, ", ");
        buf.append(")");
        if (!this.effectiveExceptionTypes.isEmpty()) {
            buf.append(" throws ");
            CollectionUtil.join(buf, this.effectiveExceptionTypes, ", ");
        }
        return buf.toString();
    }

    private void appendIfNotEmpty(StringBuilder buf, String str, String sep) {
        if (str.length() > 0) {
            buf.append(str).append(sep);
        }
    }
}

