/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.logconfig.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableLogger {
    private Logger log;

    protected abstract Logger getDefaultLogger();

    public final Logger getLogger() {
        if (this.log == null) {
            this.log = this.getDefaultLogger();
        }
        return this.log;
    }

    public final void setLogName(String logName) {
        if (logName != null && (logName = logName.trim()).length() == 0) {
            logName = null;
        }
        if (logName != null) {
            this.log = LoggerFactory.getLogger((String)logName);
        }
    }

    public final boolean isLevelEnabled(Level level) {
        Logger log = this.getLogger();
        if (level != null) {
            switch (level) {
                case trace: {
                    return log.isTraceEnabled();
                }
                case debug: {
                    return log.isDebugEnabled();
                }
                case info: {
                    return log.isInfoEnabled();
                }
                case warn: {
                    return log.isWarnEnabled();
                }
                case error: {
                    return log.isErrorEnabled();
                }
            }
        }
        this.unknownLogLevel(level);
        return false;
    }

    public final void log(Level level, String message) {
        this.log(level, message, null);
    }

    public final void log(Level level, String message, Throwable e) {
        Logger log = this.getLogger();
        if (level != null) {
            switch (level) {
                case trace: {
                    log.trace(message, e);
                    return;
                }
                case debug: {
                    log.debug(message, e);
                    return;
                }
                case info: {
                    log.info(message, e);
                    return;
                }
                case warn: {
                    log.warn(message, e);
                    return;
                }
                case error: {
                    log.error(message, e);
                    return;
                }
            }
        }
        this.unknownLogLevel(level);
    }

    private void unknownLogLevel(Level level) {
        throw new IllegalArgumentException("Unknown log level: " + (Object)((Object)level));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getLogger().getName() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        trace,
        debug,
        info,
        warn,
        error;

    }
}

