/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.configuration.support;

import com.alibaba.citrus.service.configuration.Configuration;
import com.alibaba.citrus.service.configuration.ProductionModeAware;
import com.alibaba.citrus.util.Assert;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ProductionModeAwarePostProcessor
implements BeanPostProcessor {
    private final Configuration configuration;

    public ProductionModeAwarePostProcessor(Configuration configuration) {
        this.configuration = Assert.assertNotNull(configuration, "configuration", new Object[0]);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ProductionModeAware) {
            ((ProductionModeAware)bean).setProductionMode(this.configuration.isProductionMode());
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

