/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl;

import com.alibaba.citrus.service.form.Field;
import com.alibaba.citrus.service.form.MessageContext;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorContextImpl
implements Validator.Context {
    private final MessageContext expressionContext;
    private final Field field;
    private String message;
    private Object value;

    public ValidatorContextImpl(MessageContext expressionContext, Field field) {
        this(expressionContext, field, null, false);
    }

    public ValidatorContextImpl(MessageContext expressionContext, Field field, Object value) {
        this(expressionContext, field, value, true);
    }

    private ValidatorContextImpl(MessageContext expressionContext, Field field, Object value, boolean withValue) {
        this.expressionContext = Assert.assertNotNull(expressionContext, "expressionContext", new Object[0]);
        this.field = Assert.assertNotNull(field, "field", new Object[0]);
        this.value = withValue ? value : field.getValue();
    }

    @Override
    public MessageContext getMessageContext() {
        return this.expressionContext;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Field getField(String fieldName) {
        return this.field.getGroup().getField(fieldName);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public <T> T getValueAsType(Class<T> type) {
        return type.cast(this.field.getGroup().getForm().getTypeConverter().convertIfNecessary(this.value, type));
    }

    public String toString() {
        return "ValidatorContext[" + this.field + "]";
    }
}

