/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation;

import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.support.AbstractOptionalValidator;
import com.alibaba.citrus.service.form.support.AbstractValidatorDefinitionParser;

public class StringLengthValidator
extends AbstractOptionalValidator {
    private int minLength = 0;
    private int maxLength = -1;

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    protected boolean validate(Validator.Context context, String value) {
        int length = this.getLength(value);
        if (this.minLength >= 0 && length < this.minLength) {
            return false;
        }
        return this.maxLength < 0 || length <= this.maxLength;
    }

    protected int getLength(String value) {
        return value.length();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractValidatorDefinitionParser<StringLengthValidator> {
    }
}

