/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl.validation.composite;

import com.alibaba.citrus.service.form.Condition;
import com.alibaba.citrus.service.form.Validator;
import com.alibaba.citrus.service.form.impl.condition.JexlCondition;
import com.alibaba.citrus.service.form.support.AbstractCompositeValidatorDefinitionParser;
import com.alibaba.citrus.service.form.support.AbstractSimpleCompositeValidator;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class IfValidator
extends AbstractSimpleCompositeValidator {
    private Condition condition;

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    protected boolean requiresMessage() {
        return false;
    }

    protected void init() throws Exception {
        super.init();
        Assert.assertNotNull(this.condition, "no condition", new Object[0]);
    }

    public boolean validate(Validator.Context context) {
        return !this.condition.isSatisfied(context) || this.doValidate(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractCompositeValidatorDefinitionParser<IfValidator>
    implements ContributionAware {
        private ConfigurationPoint conditionConfigurationPoint;

        @Override
        public void setContribution(Contribution contrib) {
            super.setContribution(contrib);
            this.conditionConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/form/conditions", contrib);
        }

        @Override
        protected void doParseAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            String testExpr = StringUtil.trimToNull(element.getAttribute("test"));
            if (testExpr != null) {
                BeanDefinitionBuilder jexlCondition = BeanDefinitionBuilder.genericBeanDefinition(JexlCondition.class);
                jexlCondition.addConstructorArgValue((Object)testExpr);
                builder.addPropertyValue("condition", (Object)jexlCondition.getBeanDefinition());
            }
        }

        @Override
        protected void doParseElement(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            super.doParseElement(element, parserContext, builder);
            for (Element subElement : DomUtil.subElements(element)) {
                BeanDefinitionHolder condition = SpringExtUtil.parseConfigurationPointBean(subElement, this.conditionConfigurationPoint, parserContext, builder);
                if (condition == null) continue;
                builder.addPropertyValue("condition", (Object)condition);
                break;
            }
        }
    }
}

