/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.builder.content;

import com.alibaba.citrus.service.mail.builder.MailContent;
import com.alibaba.citrus.service.mail.builder.Multipart;
import com.alibaba.citrus.service.mail.builder.content.AbstractContent;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;

public abstract class MultipartContent
extends AbstractContent
implements Multipart {
    private final List<MailContent> contents = CollectionUtil.createLinkedList();

    public void setContents(MailContent[] contents) {
        if (contents != null) {
            this.contents.clear();
            for (MailContent content : contents) {
                this.addContent(content);
            }
        }
    }

    public void addContent(MailContent content) {
        if (content != null) {
            content.setParentContent(this);
            this.contents.add(content);
        }
    }

    public MailContent[] getContents() {
        return this.contents.toArray(new MailContent[this.contents.size()]);
    }

    public void render(Part mailPart) throws MessagingException {
        javax.mail.Multipart multipart = this.getMultipart();
        if (this.contents.isEmpty()) {
            throw new MessagingException("Empty multipart");
        }
        for (MailContent content : this.contents) {
            MimeBodyPart bodyPart = new MimeBodyPart();
            content.render((Part)bodyPart);
            multipart.addBodyPart((BodyPart)bodyPart);
        }
        mailPart.setContent(multipart);
    }

    protected abstract javax.mail.Multipart getMultipart();

    protected void copyTo(AbstractContent copy) {
        for (MailContent content : this.contents) {
            ((MultipartContent)copy).addContent(content.clone());
        }
    }

    public void toString(ToStringBuilder buf) {
        buf.append(this.contents);
    }
}

