/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mappingrule.impl.rule;

import com.alibaba.citrus.service.mappingrule.support.AbstractMappingRule;
import com.alibaba.citrus.service.mappingrule.support.AbstractMappingRuleDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionMappingRule
extends AbstractMappingRule {
    private Map<String, String> extensionMappings;

    public void setExtensionMappings(Map<String, String> extensions) {
        this.extensionMappings = extensions;
    }

    @Override
    protected void initMappingRule() throws Exception {
        if (this.extensionMappings == null) {
            this.extensionMappings = CollectionUtil.createHashMap();
        }
    }

    @Override
    protected boolean isCacheEnabledByDefault() {
        return false;
    }

    @Override
    public String doMapping(String name) {
        FileUtil.FileNameAndExtension names = FileUtil.getFileNameAndExtension(name, true);
        String extension = names.getExtension();
        extension = extension == null ? "" : extension.toLowerCase();
        if (this.extensionMappings.containsKey(extension)) {
            String mapToExtension = this.extensionMappings.get(extension);
            name = names.getFileName();
            if (!(name.length() != 0 && StringUtil.contains(",/", name.charAt(name.length() - 1)) || StringUtil.isEmpty(mapToExtension))) {
                name = name + "." + mapToExtension;
            }
        } else if (StringUtil.isEmpty(extension)) {
            name = names.getFileName();
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefinitionParser
    extends AbstractMappingRuleDefinitionParser<ExtensionMappingRule> {
        @Override
        protected void doParseMappingRule(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            Map<Object, Object> extensionMappings = SpringExtUtil.createManagedMap(element, parserContext);
            for (Element subElement : DomUtil.subElements(element, DomUtil.and(DomUtil.sameNs(element), DomUtil.name("mapping")))) {
                String from = StringUtil.trimToEmpty(subElement.getAttribute("extension")).toLowerCase();
                String to = StringUtil.trimToEmpty(subElement.getAttribute("to")).toLowerCase();
                extensionMappings.put(from, to);
            }
            builder.addPropertyValue("extensionMappings", extensionMappings);
        }
    }
}

