/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.pipeline.LabelNotDefinedException;
import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.PipelineException;
import com.alibaba.citrus.service.pipeline.PipelineInvocationHandle;
import com.alibaba.citrus.service.pipeline.Valve;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Map;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineImpl
extends AbstractService<Pipeline>
implements Pipeline {
    private Valve[] valves;
    private String label;

    public Valve[] getValves() {
        return this.valves;
    }

    public void setValves(Valve[] valves) {
        this.valves = valves;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = StringUtil.trimToNull(label);
    }

    @Override
    protected void init() {
        if (this.valves == null) {
            this.valves = new Valve[0];
        }
        for (int i = 0; i < this.valves.length; ++i) {
            Assert.assertNotNull(this.valves[i], "valves[%d] == null", i);
        }
    }

    @Override
    public PipelineInvocationHandle newInvocation() {
        return new PipelineContextImpl(null);
    }

    @Override
    public PipelineInvocationHandle newInvocation(PipelineContext parentContext) {
        return new PipelineContextImpl(Assert.assertNotNull(parentContext, "no parent PipelineContext", new Object[0]));
    }

    @Override
    public String toString() {
        return new ToStringBuilder().append(this.getBeanDescription()).append(this.valves).toString();
    }

    private final class PipelineContextImpl
    implements PipelineContext,
    PipelineInvocationHandle {
        private final Logger log;
        private final PipelineContext parentContext;
        private final int level;
        private int executedIndex;
        private int executingIndex;
        private boolean broken;
        private Map<String, Object> attributes;

        public PipelineContextImpl(PipelineContext parentContext) {
            this.log = PipelineImpl.this.getLogger();
            this.executedIndex = -1;
            this.executingIndex = -1;
            this.parentContext = parentContext;
            this.level = parentContext == null ? 1 : parentContext.level() + 1;
        }

        public int level() {
            return this.level;
        }

        public int index() {
            return this.executingIndex + 1;
        }

        public int findLabel(String label) throws LabelNotDefinedException {
            boolean isTop = "#TOP".equals(label = Assert.assertNotNull(StringUtil.trimToNull(label), "no label", new Object[0]));
            if (isTop && this.parentContext == null) {
                return 0;
            }
            if (label.equals(PipelineImpl.this.getLabel())) {
                return 0;
            }
            if (this.parentContext != null) {
                return this.parentContext.findLabel(label) + 1;
            }
            throw new LabelNotDefinedException("Could not find pipeline or sub-pipeline with label \"" + label + "\" in the pipeline invocation stack");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeNext() {
            block17: {
                PipelineImpl.this.assertInitialized();
                if (this.broken) {
                    return;
                }
                try {
                    ++this.executingIndex;
                    if (this.executingIndex <= this.executedIndex) {
                        throw new IllegalStateException(this.descCurrentValve() + " has already been invoked: " + PipelineImpl.this.valves[this.executingIndex]);
                    }
                    ++this.executedIndex;
                    if (this.executingIndex < PipelineImpl.this.valves.length) {
                        Valve valve = PipelineImpl.this.valves[this.executingIndex];
                        try {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Entering {}: {}", (Object)this.descCurrentValve(), (Object)valve);
                            }
                            valve.invoke(this);
                        }
                        catch (PipelineException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new PipelineException("Failed to invoke " + this.descCurrentValve() + ": " + valve, e);
                        }
                        finally {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("...Exited {}: {}", (Object)this.descCurrentValve(), (Object)valve);
                            }
                        }
                        if (this.executedIndex < PipelineImpl.this.valves.length && this.executedIndex == this.executingIndex && this.log.isTraceEnabled()) {
                            this.log.trace("{} execution was interrupted by {}: {}", new Object[]{this.descCurrentPipeline(), this.descCurrentValve(), valve});
                        }
                        break block17;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("{} reaches its end.", (Object)this.descCurrentPipeline());
                    }
                }
                finally {
                    --this.executingIndex;
                }
            }
        }

        public void breakPipeline(int levels) {
            Assert.assertTrue(levels >= 0 && levels < this.level, "invalid break levels: %d, should be in range of [0, %d)", levels, this.level);
            this.broken = true;
            if (levels > 0) {
                this.parentContext.breakPipeline(levels - 1);
            }
        }

        public void breakPipeline(String label) throws LabelNotDefinedException {
            this.breakPipeline(this.findLabel(label));
        }

        public boolean isBroken() {
            return this.broken;
        }

        public boolean isFinished() {
            return !this.broken && this.executedIndex >= PipelineImpl.this.valves.length;
        }

        public void invoke() throws IllegalStateException {
            Assert.assertTrue(!this.isBroken(), Assert.ExceptionType.ILLEGAL_STATE, "cannot reinvoke a broken pipeline", new Object[0]);
            this.executedIndex = -1;
            this.executingIndex = -1;
            this.invokeNext();
        }

        public Object getAttribute(String key) {
            Object value = null;
            if (this.attributes != null) {
                value = this.attributes.get(key);
            }
            if (value == null && this.parentContext != null) {
                value = this.parentContext.getAttribute(key);
            }
            return value == BasicConstant.NULL_PLACEHOLDER ? null : value;
        }

        public void setAttribute(String key, Object value) {
            if (this.attributes == null) {
                this.attributes = CollectionUtil.createHashMap();
            }
            this.attributes.put(key, ObjectUtil.defaultIfNull(value, BasicConstant.NULL_PLACEHOLDER));
        }

        public String toString() {
            return "Executing Pipeline " + this.descCurrentValve();
        }

        private String descCurrentPipeline() {
            return "Pipeline[level " + this.level() + "]";
        }

        private String descCurrentValve() {
            return "Valve[#" + this.index() + "/" + PipelineImpl.this.valves.length + ", level " + this.level() + "]";
        }
    }
}

