/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.support;

import com.alibaba.citrus.service.pipeline.support.AbstractCompositeCondition;
import com.alibaba.citrus.service.pipeline.support.AbstractConditionDefinitionParser;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCompositeConditionDefinitionParser<C extends AbstractCompositeCondition>
extends AbstractConditionDefinitionParser<C>
implements ContributionAware {
    private ConfigurationPoint conditionConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.conditionConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/pipeline/conditions", contrib);
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        List<Object> conditions = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder condition = SpringExtUtil.parseConfigurationPointBean(subElement, this.conditionConfigurationPoint, parserContext, builder);
            if (condition == null) continue;
            conditions.add(condition);
        }
        builder.addPropertyValue("conditions", conditions);
    }
}

