/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pull.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.pull.PullContext;
import com.alibaba.citrus.service.pull.PullException;
import com.alibaba.citrus.service.pull.PullService;
import com.alibaba.citrus.service.pull.RuntimeToolSetFactory;
import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.service.pull.ToolNameAware;
import com.alibaba.citrus.service.pull.ToolSetFactory;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullServiceImpl
extends AbstractService<PullService>
implements PullService,
ApplicationContextAware {
    private static final String DEFAULT_BEAN_NAME = "pullService";
    private static final int SINGLETON = 1;
    private static final int TOOL_FACTORY = 2;
    private static final int TOOL_SET_FACTORY = 4;
    private static final int RUNTIME_TOOL_SET_FACTORY = 8;
    private static final AtomicInteger contextKeyCounter = new AtomicInteger();
    private ApplicationContext beanFactory;
    private PullService parent;
    private String contextKey;
    private Map<String, Object> toolFactories;
    private Map<String, ToolFactory> tools;
    private Map<String, ToolSetInfo<ToolSetFactory>> toolsInSet;
    private Map<String, RuntimeToolSetFactory> toolsRuntime;
    private Map<String, Object> prePulledTools;
    private Set<ToolName> toolNames;

    public void setApplicationContext(ApplicationContext factory) {
        this.beanFactory = factory;
    }

    public void setParent(PullService parent) {
        this.parent = parent;
    }

    public void setToolFactories(Map<String, Object> factories) {
        this.toolFactories = factories;
    }

    @Override
    protected void init() {
        this.initParent();
        this.initContextKey();
        this.initToolFactories();
        this.getLogger().info("Initialized pull service [key={}] with {} pre-pulled tools, {} pre-queued tools and {} runtime tools", new Object[]{this.contextKey, this.prePulledTools.size(), this.tools.size() + this.toolsInSet.size(), this.toolsRuntime.size()});
    }

    private void initParent() {
        if (this.parent != null || this.beanFactory == null || this.beanFactory.getParent() == null) {
            return;
        }
        String parentBeanName = null;
        if (this.beanFactory.getParent().containsBean(this.getBeanName())) {
            parentBeanName = this.getBeanName();
        } else if (this.beanFactory.getParent().containsBean(DEFAULT_BEAN_NAME)) {
            parentBeanName = DEFAULT_BEAN_NAME;
        }
        if (parentBeanName != null) {
            this.parent = (PullService)this.beanFactory.getParent().getBean(parentBeanName);
        }
    }

    private void initContextKey() {
        int i = contextKeyCounter.getAndIncrement();
        this.contextKey = "PullService." + this.getBeanName() + (i > 0 ? "." + i : "");
    }

    private void initToolFactories() {
        this.tools = CollectionUtil.createHashMap();
        this.toolsInSet = CollectionUtil.createHashMap();
        this.toolsRuntime = CollectionUtil.createHashMap();
        this.prePulledTools = CollectionUtil.createHashMap();
        this.toolNames = CollectionUtil.createHashSet();
        if (this.toolFactories != null) {
            for (Map.Entry<String, Object> e : this.toolFactories.entrySet()) {
                Iterable<String> names;
                int type;
                String name = Assert.assertNotNull(StringUtil.trimToNull(e.getKey()), "tool name", new Object[0]);
                Object factory = e.getValue();
                if (factory instanceof ToolNameAware) {
                    ((ToolNameAware)factory).setToolName(name);
                }
                if (PullServiceImpl.testBit(type = PullServiceImpl.getFactoryType(factory), 1)) {
                    if (PullServiceImpl.testBit(type, 2)) {
                        Object tool;
                        try {
                            tool = PullServiceImpl.encode(((ToolFactory)factory).createTool());
                        }
                        catch (Exception ex) {
                            throw new PullException("Could not create tool: \"" + name + "\"", ex);
                        }
                        ToolName toolName = new ToolName(null, name, false);
                        this.toolNames.add(toolName);
                        this.prePulledTools.put(name, tool);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Pre-pulled tool: {} = {}", (Object)toolName, tool);
                        }
                    }
                    if (!PullServiceImpl.testBit(type, 4) || (names = ((ToolSetFactory)factory).getToolNames()) == null) continue;
                    for (String nameInSet : names) {
                        Object tool;
                        if ((nameInSet = StringUtil.trimToNull(nameInSet)) == null) continue;
                        try {
                            tool = PullServiceImpl.encode(((ToolSetFactory)factory).createTool(nameInSet));
                        }
                        catch (Exception ex) {
                            throw new PullException("Could not create tool: \"" + name + "." + nameInSet + "\"", ex);
                        }
                        ToolName toolName = new ToolName(name, nameInSet, false);
                        this.toolNames.add(toolName);
                        this.prePulledTools.put(nameInSet, tool);
                        if (!this.getLogger().isDebugEnabled()) continue;
                        this.getLogger().debug("Pre-pulled tool: {} = {}", (Object)toolName, tool);
                    }
                    continue;
                }
                if (PullServiceImpl.testBit(type, 2)) {
                    ToolName toolName = new ToolName(null, name, false);
                    this.toolNames.add(toolName);
                    this.tools.put(name, (ToolFactory)factory);
                    this.getLogger().debug("Pre-queued tool: {}", (Object)toolName);
                }
                if (PullServiceImpl.testBit(type, 4) && (names = ((ToolSetFactory)factory).getToolNames()) != null) {
                    for (String nameInSet : names) {
                        if ((nameInSet = StringUtil.trimToNull(nameInSet)) == null) continue;
                        ToolName toolName = new ToolName(name, nameInSet, false);
                        this.toolNames.add(toolName);
                        this.toolsInSet.put(nameInSet, new ToolSetInfo<ToolSetFactory>(name, (ToolSetFactory)factory, null));
                        this.getLogger().debug("Pre-queued tool: {}", (Object)toolName);
                    }
                }
                if (!PullServiceImpl.testBit(type, 8)) continue;
                this.toolsRuntime.put(name, (RuntimeToolSetFactory)factory);
            }
        }
        this.toolFactories = null;
    }

    @Override
    public PullContext getContext() {
        PullContext context;
        RequestAttributes attrs = null;
        try {
            attrs = RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException e) {
            this.getLogger().debug("Getting pull context in non-WEB environment: {}", (Object)e.getMessage());
        }
        if (attrs == null) {
            context = new PullContextImpl();
        } else {
            context = (PullContext)attrs.getAttribute(this.contextKey, 0);
            if (context == null) {
                context = new PullContextImpl();
                attrs.setAttribute(this.contextKey, (Object)context, 0);
            }
        }
        return context;
    }

    @Override
    public Map<String, Object> getTools() {
        return this.getContext().getTools();
    }

    private static int getFactoryType(Object factory) {
        int type = 0;
        if (factory instanceof RuntimeToolSetFactory) {
            type |= 8;
            if (factory instanceof ToolFactory) {
                type |= 2;
            }
            return type;
        }
        if (factory instanceof ToolFactory) {
            type |= 2;
            if (((ToolFactory)factory).isSingleton()) {
                type |= 1;
            }
        }
        if (factory instanceof ToolSetFactory) {
            type |= 4;
            if (((ToolSetFactory)factory).isSingleton()) {
                type |= 1;
            }
        }
        Assert.assertTrue(type != 0, "unknown pull tool factory type: %s", factory == null ? null : factory.getClass().getName());
        return type;
    }

    private static boolean testBit(int type, int mask) {
        return (type & mask) != 0;
    }

    private static Object encode(Object value) {
        return value == null ? BasicConstant.NULL_PLACEHOLDER : value;
    }

    private static Object decode(Object value) {
        return value == BasicConstant.NULL_PLACEHOLDER ? null : value;
    }

    @Override
    public String toString() {
        if (this.isInitialized()) {
            ToStringBuilder sb = new ToStringBuilder().append("PullTools").append(new ToStringBuilder.CollectionBuilder().appendAll(this.toolNames).setPrintCount(true).setSort(true));
            if (this.parent != null) {
                sb.append("Parent ").append(this.parent);
            }
            return sb.toString();
        }
        return "PullTools[uninitialized]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ToolName
    implements Comparable<ToolName> {
        private final String qname;
        private final String name;

        public ToolName(String namespace, String name, boolean parse) {
            int index;
            namespace = StringUtil.trimToNull(namespace);
            name = Assert.assertNotNull(StringUtil.trimToNull(name), "tool name", new Object[0]);
            if (parse && (index = (name = StringUtil.trim(name, "/")).lastIndexOf("/")) >= 0) {
                namespace = namespace == null ? name.substring(0, index) : namespace + "/" + name.substring(0, index);
                namespace = StringUtil.trim(namespace, "/");
                name = name.substring(index + 1);
            }
            this.qname = namespace == null ? "/" + name : "/" + namespace + "/" + name;
            this.name = name;
        }

        public String getQualifiedName() {
            return this.qname;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(ToolName o) {
            return this.qname.compareTo(o.qname);
        }

        public int hashCode() {
            return 31 + this.qname.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ToolName)) {
                return false;
            }
            return this.qname.equals(((ToolName)obj).qname);
        }

        public String toString() {
            return this.qname;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PullContextImpl
    implements PullContext {
        private final PullContext parentContext;
        private final Map<String, Object> pulledTools;
        private final Map<String, RuntimeToolSetFactory> toolsRuntime;
        private final Map<String, ToolSetInfo<RuntimeToolSetFactory>> toolsInRuntimeSet;
        private final Set<ToolName> toolNames;
        private Set<String> toolNamesIncludingParent;
        private Map<String, Object> toolsIncludingParent;

        private PullContextImpl() {
            this.parentContext = PullServiceImpl.this.parent == null ? null : PullServiceImpl.this.parent.getContext();
            this.pulledTools = CollectionUtil.createHashMap();
            this.toolsRuntime = CollectionUtil.createTreeMap();
            this.toolsInRuntimeSet = CollectionUtil.createHashMap();
            this.toolNames = CollectionUtil.createHashSet();
            this.toolsRuntime.putAll(PullServiceImpl.this.toolsRuntime);
            this.toolNames.addAll(PullServiceImpl.this.toolNames);
        }

        @Override
        public Object pull(String name) {
            if ((name = StringUtil.trimToNull(name)) == null) {
                return null;
            }
            Object tool = PullServiceImpl.this.prePulledTools.get(name);
            if (tool == null && (tool = this.pulledTools.get(name)) == null && (tool = this.doPulling(name)) != null) {
                this.pulledTools.put(name, tool);
            }
            if (tool == null && this.parentContext != null) {
                return this.parentContext.pull(name);
            }
            return PullServiceImpl.decode(tool);
        }

        private Object doPulling(String name) {
            ToolFactory toolFactory = (ToolFactory)PullServiceImpl.this.tools.get(name);
            if (toolFactory != null) {
                Object tool;
                try {
                    tool = toolFactory.createTool();
                }
                catch (Exception ex) {
                    throw new PullException("Could not create tool: \"" + name + "\"", ex);
                }
                if (PullServiceImpl.this.getLogger().isDebugEnabled()) {
                    PullServiceImpl.this.getLogger().debug("Pulled tool: {} = {}", (Object)name, tool);
                }
                return PullServiceImpl.encode(tool);
            }
            ToolSetInfo toolSetInfo = (ToolSetInfo)PullServiceImpl.this.toolsInSet.get(name);
            if (toolSetInfo != null) {
                Object tool;
                try {
                    tool = ((ToolSetFactory)toolSetInfo.getFactory()).createTool(name);
                }
                catch (Exception ex) {
                    throw new PullException("Could not create tool: \"" + toolSetInfo.getToolSetName() + "." + name + "\"", ex);
                }
                if (PullServiceImpl.this.getLogger().isDebugEnabled()) {
                    PullServiceImpl.this.getLogger().debug("Pulled tool: {}.{} = {}", new Object[]{toolSetInfo.getToolSetName(), name, tool});
                }
                return PullServiceImpl.encode(tool);
            }
            this.pullToolsRuntime(name);
            ToolSetInfo<RuntimeToolSetFactory> runtimeToolSetInfo = this.toolsInRuntimeSet.get(name);
            if (runtimeToolSetInfo != null) {
                Object tool;
                try {
                    tool = runtimeToolSetInfo.getFactory().createTool(runtimeToolSetInfo.getTool(), name);
                }
                catch (Exception ex) {
                    throw new PullException("Could not create tool: \"" + runtimeToolSetInfo.getToolSetName() + "." + name + "\"", ex);
                }
                if (PullServiceImpl.this.getLogger().isDebugEnabled()) {
                    PullServiceImpl.this.getLogger().debug("Pulled tool: {}.{} = {}", new Object[]{runtimeToolSetInfo.getToolSetName(), name, tool});
                }
                return PullServiceImpl.encode(tool);
            }
            return null;
        }

        private void pullToolsRuntime(String stopOnName) {
            if (stopOnName != null && this.toolsInRuntimeSet.containsKey(stopOnName)) {
                return;
            }
            Iterator<Map.Entry<String, RuntimeToolSetFactory>> i = this.toolsRuntime.entrySet().iterator();
            while (i.hasNext()) {
                Object tool;
                Map.Entry<String, RuntimeToolSetFactory> entry = i.next();
                i.remove();
                String toolSetName = entry.getKey();
                RuntimeToolSetFactory factory = entry.getValue();
                int count = 0;
                try {
                    tool = factory.createToolSet();
                }
                catch (Exception ex) {
                    throw new PullException("Could not create runtime tool-set: \"" + toolSetName + "\"", ex);
                }
                Iterable<String> names = factory.getToolNames(tool);
                if (names != null) {
                    for (String nameInSet : names) {
                        if (nameInSet == null) continue;
                        this.toolsInRuntimeSet.put(nameInSet, new ToolSetInfo<RuntimeToolSetFactory>(toolSetName, factory, tool));
                        this.toolNames.add(new ToolName(toolSetName, nameInSet, false));
                        ++count;
                    }
                }
                PullServiceImpl.this.getLogger().debug("Queued {} tools for runtime tool-set \"{}\"", (Object)count, (Object)toolSetName);
                if (stopOnName == null || !this.toolsInRuntimeSet.containsKey(stopOnName)) continue;
                break;
            }
        }

        @Override
        public Set<String> getQualifiedToolNames() {
            TreeSet<String> names = CollectionUtil.createTreeSet();
            for (ToolName toolName : this.populateToolNames()) {
                names.add(toolName.getQualifiedName());
            }
            return names;
        }

        @Override
        public Set<String> getToolNames() {
            if (this.toolNamesIncludingParent == null) {
                TreeSet names = CollectionUtil.createTreeSet();
                for (ToolName toolName : this.populateToolNames()) {
                    names.add(toolName.getName());
                }
                this.toolNamesIncludingParent = Collections.unmodifiableSet(names);
            }
            return this.toolNamesIncludingParent;
        }

        private Set<ToolName> populateToolNames() {
            HashSet<ToolName> toolNamesIncludingParent;
            this.pullToolsRuntime(null);
            if (this.parentContext == null) {
                toolNamesIncludingParent = this.toolNames;
            } else {
                toolNamesIncludingParent = CollectionUtil.createHashSet();
                for (String parentToolName : this.parentContext.getQualifiedToolNames()) {
                    toolNamesIncludingParent.add(new ToolName("_parent", parentToolName, true));
                }
                toolNamesIncludingParent.addAll(this.toolNames);
            }
            return toolNamesIncludingParent;
        }

        @Override
        public Map<String, Object> getTools() {
            if (this.toolsIncludingParent == null) {
                for (String name : PullServiceImpl.this.tools.keySet()) {
                    this.pull(name);
                }
                for (String name : PullServiceImpl.this.toolsInSet.keySet()) {
                    this.pull(name);
                }
                this.pullToolsRuntime(null);
                for (String name : this.toolsInRuntimeSet.keySet()) {
                    this.pull(name);
                }
                this.toolsIncludingParent = CollectionUtil.createHashMap();
                if (this.parentContext != null) {
                    this.toolsIncludingParent.putAll(this.parentContext.getTools());
                }
                this.putAll(this.toolsIncludingParent, this.pulledTools);
                this.putAll(this.toolsIncludingParent, PullServiceImpl.this.prePulledTools);
                this.toolsIncludingParent = Collections.unmodifiableMap(this.toolsIncludingParent);
            }
            return this.toolsIncludingParent;
        }

        private void putAll(Map<String, Object> tools, Map<String, Object> objects) {
            for (Map.Entry<String, Object> entry : objects.entrySet()) {
                tools.put(entry.getKey(), PullServiceImpl.decode(entry.getValue()));
            }
        }

        public String toString() {
            ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
            mb.append("prePulledTools", new ToStringBuilder.MapBuilder().appendAll(PullServiceImpl.this.prePulledTools).setSortKeys(true).setPrintCount(true));
            mb.append("pulledTools", new ToStringBuilder.MapBuilder().appendAll(this.pulledTools).setSortKeys(true).setPrintCount(true));
            ToStringBuilder sb = new ToStringBuilder().append("PullContext").append(mb);
            if (this.parentContext != null) {
                sb.append("Parent ").append(this.parentContext);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ToolSetInfo<F> {
        private final String toolSetName;
        private final F factory;
        private final Object tool;

        public ToolSetInfo(String toolSetName, F factory, Object tool) {
            this.toolSetName = toolSetName;
            this.factory = factory;
            this.tool = tool;
        }

        public String getToolSetName() {
            return this.toolSetName;
        }

        public F getFactory() {
            return this.factory;
        }

        public Object getTool() {
            return this.tool;
        }
    }
}

