/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.basic.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.RequestContextException;
import com.alibaba.citrus.service.requestcontext.basic.BasicRequestContext;
import com.alibaba.citrus.service.requestcontext.basic.impl.BasicResponseImpl;
import com.alibaba.citrus.service.requestcontext.basic.impl.ResponseHeaderSecurityFilter;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextWrapper;
import com.alibaba.citrus.util.ArrayUtil;
import javax.servlet.http.HttpServletResponse;

public class BasicRequestContextImpl
extends AbstractRequestContextWrapper
implements BasicRequestContext {
    private Object[] interceptors;

    public BasicRequestContextImpl(RequestContext wrappedContext, Object[] interceptors) {
        super(wrappedContext);
        this.interceptors = this.addDefaultInterceptors(interceptors);
        this.setResponse((HttpServletResponse)new BasicResponseImpl(this, wrappedContext.getResponse(), this.interceptors));
    }

    public Object[] getResponseHeaderInterceptors() {
        return (Object[])this.interceptors.clone();
    }

    public void prepare() {
        ((BasicResponseImpl)this.getResponse()).prepareResponse();
    }

    public void commitHeaders() throws RequestContextException {
        ((BasicResponseImpl)this.getResponse()).commitHeaders();
    }

    public void commit() throws RequestContextException {
        ((BasicResponseImpl)this.getResponse()).commitResponse();
    }

    private Object[] addDefaultInterceptors(Object[] interceptors) {
        if (ArrayUtil.isEmptyArray(interceptors)) {
            return new Object[]{new ResponseHeaderSecurityFilter()};
        }
        for (Object interceptor : interceptors) {
            if (!(interceptor instanceof ResponseHeaderSecurityFilter)) continue;
            return interceptors;
        }
        Object[] newInterceptors = new Object[interceptors.length + 1];
        System.arraycopy(interceptors, 0, newInterceptors, 0, interceptors.length);
        newInterceptors[interceptors.length] = new ResponseHeaderSecurityFilter();
        return newInterceptors;
    }
}

